/*
 * Decompiled with CFR 0.152.
 */
package GPos.VuposInstallationWizard;

import java.awt.Color;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FolderEntryField
extends JTextField {
    public FolderEntryField() {
        this.setText(".");
    }

    public FolderEntryField(int cols) {
        super(cols);
        this.setText(".");
    }

    public FolderEntryField(String input, int cols) {
        super(cols);
        this.setText(input);
    }

    protected Document createDefaultModel() {
        return new FolderOnlyDocument();
    }

    public String getDefault() {
        return ((FolderOnlyDocument)this.getDocument()).getDefault();
    }

    public void init(String input, String default_input) {
        ((FolderOnlyDocument)this.getDocument()).setDefault(default_input);
        this.setText(input);
        this.setSelectionStart(0);
        this.setSelectionEnd(input.length());
    }

    public boolean isError() {
        return ((FolderOnlyDocument)this.getDocument()).isError();
    }

    public boolean isOk() {
        return ((FolderOnlyDocument)this.getDocument()).isOk();
    }

    public boolean isWarning() {
        return ((FolderOnlyDocument)this.getDocument()).isWarning();
    }

    public void setColor(Color foreground, Color background) {
        this.setBackground(background);
        this.setForeground(foreground);
    }

    public void setDefault(String input) {
        ((FolderOnlyDocument)this.getDocument()).setDefault(input);
    }

    class FolderOnlyDocument
    extends PlainDocument {
        private STATUS Status_ = STATUS.OK;
        private String Default_ = null;

        private STATUS testString(String input) {
            if (input == null || input.length() == 0) {
                return STATUS.ERROR;
            }
            File file = new File(input);
            if (file.exists()) {
                if (file.isDirectory()) {
                    if (file.canRead() && file.canWrite()) {
                        return STATUS.OK;
                    }
                    return STATUS.WARNING;
                }
                return STATUS.ERROR;
            }
            return STATUS.ERROR;
        }

        public String getDefault() {
            return this.Default_;
        }

        public STATUS getStatus() {
            return this.Status_;
        }

        public void insertString(int offs, String str, AttributeSet as) throws BadLocationException {
            if (str != null && str.length() > 0) {
                String tmp = offs < super.getLength() ? super.getText(0, offs) + str + super.getText(offs, super.getLength() - offs) : super.getText(0, super.getLength()) + str;
                super.remove(0, super.getLength());
                this.Status_ = this.testString(tmp);
                FolderEntryField.this.setColor(this.Status_.getForeground(), this.Status_.getBackground());
                super.insertString(0, tmp, as);
            }
        }

        public boolean isError() {
            return this.Status_.equals((Object)STATUS.ERROR);
        }

        public boolean isOk() {
            return this.Status_.equals((Object)STATUS.OK);
        }

        public boolean isWarning() {
            return this.Status_.equals((Object)STATUS.WARNING);
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            this.Status_ = this.testString(super.getText(0, super.getLength()));
            FolderEntryField.this.setColor(this.Status_.getForeground(), this.Status_.getBackground());
        }

        public void setDefault(String input) {
            this.Default_ = input;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATUS {
        ERROR(Color.WHITE, Color.RED),
        OK(Color.BLACK, Color.WHITE),
        WARNING(Color.BLACK, Color.PINK);

        private final Color Background_;
        private final Color Foreground_;

        private STATUS(Color foreground, Color background) {
            this.Background_ = background;
            this.Foreground_ = foreground;
        }

        public Color getBackground() {
            return this.Background_;
        }

        public Color getForeground() {
            return this.Foreground_;
        }
    }
}

