/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GPos.Vupos.DotPltFileFilter;
import GPos.Vupos.PlotControls;
import GPosGui.GPosFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class Vupos
extends GPosFrame {
    private final String Key_ = "E1EEQgLss3";
    private JMenuItem AboutItem_;
    private JMenuItem AdvancedItem_;
    private JMenu AttributesMenu_;
    private JPanel ControlPanel_;
    private JMenu DateFormatMenu_;
    private JMenu FileMenu_;
    private JMenuItem GuiItem_;
    private JMenuItem HelpItem_;
    private JMenu HelpMenu_;
    private JMenuItem LongTimeFormatItem_;
    private JMenuBar MenuBar_;
    private JMenuItem OpenFileItem_;
    private JMenuItem PrintFileItem_;
    private JMenuItem QuitItem_;
    private JMenuItem SaveFileItem_;
    private JMenuItem ShortTimeFormatItem_;
    private JMenuItem StartedItem_;
    private JMenuItem TitleItem_;
    private JMenuItem XAxisItem_;
    private JMenuItem XLabelItem_;
    private JMenuItem YAxisItem_;
    private JMenuItem YLabelItem_;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private final String HelpSetName_ = "VuposHelp.hs";
    private HelpBroker HelpBroker_;
    private HelpSet HelpSet_;
    private static final ImageIcon BigIcon_ = Vupos.createImageIcon("/GPosGui/images/gpos_logo48.gif", "Powered by GPos logo");
    private static final ImageIcon SmallIcon_ = Vupos.createImageIcon("/GPosGui/images/gpos_logo16.gif", "GPos logo");

    public Vupos(String file_name, boolean help_flag, String date_format, String starting_directory) {
        super("vupos", "1.1.10", Locale.getDefault());
        this.setDefaultCloseOperation(3);
        this.Info_ = "a GNSS plotting tool";
        this.initialization(file_name, help_flag, date_format, starting_directory);
    }

    public Vupos(GPosFrame parent, String file_name, boolean help_flag, String date_format, String starting_directory) {
        super((Object)parent);
        this.setDefaultCloseOperation(1);
        this.initialization(file_name, help_flag, date_format, starting_directory);
    }

    private void initComponents() {
        this.ControlPanel_ = new PlotControls(this);
        this.MenuBar_ = new JMenuBar();
        this.FileMenu_ = new JMenu();
        this.OpenFileItem_ = new JMenuItem();
        this.SaveFileItem_ = new JMenuItem();
        this.PrintFileItem_ = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.QuitItem_ = new JMenuItem();
        this.AttributesMenu_ = new JMenu();
        this.TitleItem_ = new JMenuItem();
        this.XLabelItem_ = new JMenuItem();
        this.YLabelItem_ = new JMenuItem();
        this.XAxisItem_ = new JMenuItem();
        this.YAxisItem_ = new JMenuItem();
        this.DateFormatMenu_ = new JMenu();
        this.LongTimeFormatItem_ = new JMenuItem();
        this.ShortTimeFormatItem_ = new JMenuItem();
        this.HelpMenu_ = new JMenu();
        this.HelpItem_ = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.StartedItem_ = new JMenuItem();
        this.GuiItem_ = new JMenuItem();
        this.AdvancedItem_ = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.AboutItem_ = new JMenuItem();
        this.AboutItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.AboutActionPerformed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.ControlPanel_, gridBagConstraints);
        this.FileMenu_.setMnemonic(this.i18nString("FileMnemonic", "F").charAt(0));
        this.FileMenu_.setText(this.i18nString("File", "File"));
        this.FileMenu_.setToolTipText(this.i18nString("FileToolTip", "Open and save files."));
        this.OpenFileItem_.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.OpenFileItem_.setMnemonic(this.i18nString("OpenMnemonic", "O").charAt(0));
        this.OpenFileItem_.setText(this.i18nString("Open", "Open"));
        this.OpenFileItem_.setToolTipText(this.i18nString("OpenToolTip", "Open."));
        this.OpenFileItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.OpenFileItem_ActionPerformed(evt);
            }
        });
        this.FileMenu_.add(this.OpenFileItem_);
        this.SaveFileItem_.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.SaveFileItem_.setMnemonic(this.i18nString("SaveMnemonic", "S").charAt(0));
        this.SaveFileItem_.setText(this.i18nString("Save", "Save"));
        this.SaveFileItem_.setToolTipText(this.i18nString("SaveToolTip", "Save."));
        this.SaveFileItem_.setEnabled(false);
        this.SaveFileItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.SaveFileItem_ActionPerformed(evt);
            }
        });
        this.FileMenu_.add(this.SaveFileItem_);
        this.PrintFileItem_.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.PrintFileItem_.setMnemonic(this.i18nString("PrintMnemonic", "P").charAt(0));
        this.PrintFileItem_.setText(this.i18nString("Print", "Print"));
        this.PrintFileItem_.setToolTipText(this.i18nString("PrintToolTip", "Print."));
        this.PrintFileItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.PrintFileItem_ActionPerformed(evt);
            }
        });
        this.FileMenu_.add(this.PrintFileItem_);
        this.FileMenu_.add(this.jSeparator1);
        this.QuitItem_.setAccelerator(this.Parent_ instanceof GPosFrame ? KeyStroke.getKeyStroke(67, 2) : KeyStroke.getKeyStroke(81, 2));
        this.QuitItem_.setMnemonic(this.Parent_ instanceof GPosFrame ? this.i18nString("CloseMnemonic", "C").charAt(0) : this.i18nString("QuitMnemonic", "Q").charAt(0));
        this.QuitItem_.setText(this.Parent_ instanceof GPosFrame ? this.i18nString("Close", "Close") : this.i18nString("Quit", "Quit"));
        this.QuitItem_.setToolTipText(this.Parent_ instanceof GPosFrame ? this.i18nString("CloseToolTip", "Close this window.") : this.i18nString("QuitToolTip", "Quit this program."));
        this.QuitItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.QuitItem_ActionPerformed(evt);
            }
        });
        this.FileMenu_.add(this.QuitItem_);
        this.MenuBar_.add(this.FileMenu_);
        this.AttributesMenu_.setMnemonic(this.i18nString("AttributesMnemonic", "A").charAt(0));
        this.AttributesMenu_.setText(this.i18nString("Attributes", "Attributes"));
        this.AttributesMenu_.setToolTipText(this.i18nString("AttributesToolTip", "Change the program's appearance."));
        this.TitleItem_.setMnemonic(this.i18nString("TitleItemMnemonic", "T").charAt(0));
        this.TitleItem_.setText(this.i18nString("TitleItem", "Title"));
        this.TitleItem_.setToolTipText(this.i18nString("TitleItemToolTip", "Change the plot title."));
        this.TitleItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.TitleItem_ActionPerformed(evt);
            }
        });
        this.AttributesMenu_.add(this.TitleItem_);
        this.XLabelItem_.setMnemonic(this.i18nString("XLabelItemMnemonic", "A").charAt(0));
        this.XLabelItem_.setText(this.i18nString("XLabelItem", "X Axis Label"));
        this.XLabelItem_.setToolTipText(this.i18nString("XLabelItemToolTip", "Change the X axis label."));
        this.XLabelItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.XLabelItem_ActionPerformed(evt);
            }
        });
        this.AttributesMenu_.add(this.XLabelItem_);
        this.YLabelItem_.setMnemonic(this.i18nString("YLabelItemMnemonic", "I").charAt(0));
        this.YLabelItem_.setText(this.i18nString("YLabelItem", "Y Axis Label"));
        this.YLabelItem_.setToolTipText(this.i18nString("YLabelItemToolTip", "Change the Y axis label."));
        this.YLabelItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.YLabelItem_ActionPerformed(evt);
            }
        });
        this.AttributesMenu_.add(this.YLabelItem_);
        this.XAxisItem_.setMnemonic(this.i18nString("XAxisItemMnemonic", "X").charAt(0));
        this.XAxisItem_.setText(this.i18nString("XAxisItem", "X Axis Limits"));
        this.XAxisItem_.setToolTipText(this.i18nString("XAxisItemToolTip", "Change the X axis limits."));
        this.XAxisItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.XAxisItem_ActionPerformed(evt);
            }
        });
        this.AttributesMenu_.add(this.XAxisItem_);
        this.YAxisItem_.setMnemonic(this.i18nString("YAxisItemMnemonic", "Y").charAt(0));
        this.YAxisItem_.setText(this.i18nString("YAxisItem", "Y Axis Limits"));
        this.YAxisItem_.setToolTipText(this.i18nString("YAxisItemToolTip", "Change the Y axis limits."));
        this.YAxisItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.YAxisItem_ActionPerformed(evt);
            }
        });
        this.AttributesMenu_.add(this.YAxisItem_);
        this.DateFormatMenu_.setMnemonic(this.i18nString("DateFormatMnemonic", "D").charAt(0));
        this.DateFormatMenu_.setText(this.i18nString("DateFormat", "Date Format"));
        this.DateFormatMenu_.setToolTipText(this.i18nString("DateFormatToolTip", "Select a date format."));
        this.LongTimeFormatItem_.setMnemonic(this.i18nString("LongTimeFormatMnemonic", "L").charAt(0));
        this.LongTimeFormatItem_.setText(this.i18nString("LongTimeFormat", "Long"));
        this.LongTimeFormatItem_.setToolTipText(this.i18nString("LongTimeFormatToolTip", "yyyy-mm-dd hh:mm:ss.sss"));
        this.LongTimeFormatItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.LongTimeFormatItem_ActionPerformed(evt);
            }
        });
        this.DateFormatMenu_.add(this.LongTimeFormatItem_);
        this.ShortTimeFormatItem_.setMnemonic(this.i18nString("ShortTimeFormatMnemonic", "S").charAt(0));
        this.ShortTimeFormatItem_.setText(this.i18nString("ShortTimeFormat", "Short"));
        this.ShortTimeFormatItem_.setToolTipText(this.i18nString("ShortTimeFormatToolTip", "yyyy-ddd hh:mm:ss.sss"));
        this.ShortTimeFormatItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.ShortTimeFormatItem_ActionPerformed(evt);
            }
        });
        this.DateFormatMenu_.add(this.ShortTimeFormatItem_);
        this.AttributesMenu_.add(this.DateFormatMenu_);
        this.MenuBar_.add(this.AttributesMenu_);
        this.MenuBar_.add(Box.createHorizontalGlue());
        this.HelpMenu_.setMnemonic(this.i18nString("HelpMnemonic", "H").charAt(0));
        this.HelpMenu_.setText(this.i18nString("Help", "Help"));
        this.HelpMenu_.setToolTipText(this.i18nString("HelpMenuToolTip", "Help information."));
        this.HelpItem_.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.HelpItem_.setMnemonic(this.i18nString("HelpMnemonic", "H").charAt(0));
        this.HelpItem_.setText(this.i18nString("Help", "Help"));
        this.HelpItem_.setToolTipText(this.i18nString("HelpItemToolTip", "Display the help dialog."));
        this.HelpItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.HelpItem_ActionPerformed(evt);
            }
        });
        this.HelpMenu_.add(this.HelpItem_);
        this.HelpMenu_.add(this.jSeparator2);
        this.StartedItem_.setMnemonic(this.i18nString("HelpGettingStartedItemMnemonic", "S").charAt(0));
        this.StartedItem_.setText(this.i18nString("HelpGettingStartedItem", "Getting Started"));
        this.StartedItem_.setToolTipText(this.i18nString("HelpGettingStartedItemToolTip", "Getting started tutorial."));
        this.StartedItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.StartedItem_ActionPerformed(evt);
            }
        });
        this.HelpMenu_.add(this.StartedItem_);
        this.GuiItem_.setMnemonic(this.i18nString("HelpGuiItemMnemonic", "G").charAt(0));
        this.GuiItem_.setText(this.i18nString("HelpGuiItem", "GUI"));
        this.GuiItem_.setToolTipText(this.i18nString("HelpGuiItemToolTip", "Help with the GUI controls."));
        this.GuiItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.GuiItem_ActionPerformed(evt);
            }
        });
        this.HelpMenu_.add(this.GuiItem_);
        this.AdvancedItem_.setMnemonic(this.i18nString("HelpAdvancedItemMnemonic", "D").charAt(0));
        this.AdvancedItem_.setText(this.i18nString("HelpAdvancedItem", "Advanced"));
        this.AdvancedItem_.setToolTipText(this.i18nString("HelpAdvancedItemToolTip", "Help with advanced topics."));
        this.AdvancedItem_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vupos.this.AdvancedItem_ActionPerformed(evt);
            }
        });
        this.HelpMenu_.add(this.AdvancedItem_);
        this.HelpMenu_.add(this.jSeparator3);
        this.AboutItem_.setMnemonic(this.i18nString("AboutMnemonic", "A").charAt(0));
        this.AboutItem_.setText(this.i18nString("About", "About"));
        this.AboutItem_.setToolTipText(this.i18nString("AboutToolTip", "About this program."));
        this.HelpMenu_.add(this.AboutItem_);
        this.MenuBar_.add(this.HelpMenu_);
        this.setJMenuBar(this.MenuBar_);
        this.pack();
    }

    private void ShortTimeFormatItem_ActionPerformed(ActionEvent evt) {
        this.setShortDateFormat();
    }

    private void LongTimeFormatItem_ActionPerformed(ActionEvent evt) {
        this.setLongDateFormat();
    }

    private void AdvancedItem_ActionPerformed(ActionEvent evt) {
        try {
            this.HelpBroker_.setCurrentID("advanced.overview");
            this.HelpBroker_.setDisplayed(true);
        }
        catch (Exception be) {
            JOptionPane.showMessageDialog(this, be.toString(), this.i18nString("ErrorDisplayingHelp", "Displaying Help Tool"), 0);
        }
    }

    private void GuiItem_ActionPerformed(ActionEvent evt) {
        try {
            this.HelpBroker_.setCurrentID("gui.overview");
            this.HelpBroker_.setDisplayed(true);
        }
        catch (Exception be) {
            JOptionPane.showMessageDialog(this, be.toString(), this.i18nString("ErrorDisplayingHelp", "Displaying Help Tool"), 0);
        }
    }

    private void StartedItem_ActionPerformed(ActionEvent evt) {
        try {
            this.HelpBroker_.setCurrentID("started.started");
            this.HelpBroker_.setDisplayed(true);
        }
        catch (Exception be) {
            JOptionPane.showMessageDialog(this, be.toString(), this.i18nString("ErrorDisplayingHelp", "Displaying Help Tool"), 0);
        }
    }

    private void HelpItem_ActionPerformed(ActionEvent evt) {
        try {
            this.HelpBroker_.setCurrentID("vupos.intro");
            this.HelpBroker_.setDisplayed(true);
        }
        catch (Exception be) {
            JOptionPane.showMessageDialog(this, be.toString(), this.i18nString("ErrorDisplayingHelp", "Displaying Help Tool"), 0);
        }
    }

    private void SaveFileItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).saveBreakInstructions();
        ((PlotControls)this.ControlPanel_).saveKillInstructions();
    }

    private void YLabelItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).setYAxisLabel((String)JOptionPane.showInputDialog(this, this.i18nString("YLabelItemToolTip", "Change the Y-axis label."), this.i18nString("YLabelItem", "Y-Axis Label"), 3, null, null, ((PlotControls)this.ControlPanel_).getYAxisLabel()));
    }

    private void XLabelItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).setXAxisLabel((String)JOptionPane.showInputDialog(this, this.i18nString("XLabelItemToolTip", "Change the X-axis label."), this.i18nString("XLabelItem", "X-Axis Label"), 3, null, null, ((PlotControls)this.ControlPanel_).getXAxisLabel()));
    }

    private void TitleItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).setTitle((String)JOptionPane.showInputDialog(this, this.i18nString("TitleItemToolTip", "Change the plot title."), this.i18nString("TitleItem", "Plot Title"), 3, null, null, ((PlotControls)this.ControlPanel_).getPlotTitle()));
    }

    private void YAxisItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).showYAxisDialog();
    }

    private void XAxisItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).showXAxisDialog();
    }

    private void QuitItem_ActionPerformed(ActionEvent evt) {
        if (this.Parent_ == null || this.Parent_ instanceof Vupos) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void PrintFileItem_ActionPerformed(ActionEvent evt) {
        try {
            ((PlotControls)this.ControlPanel_).print();
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(this, pe.toString(), "Print error", 0);
        }
    }

    private void OpenFileItem_ActionPerformed(ActionEvent evt) {
        ((PlotControls)this.ControlPanel_).setStatusBar(this.i18nString("SelectPlotFile", "Select a plot file."));
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.getFile("PLOT"));
        chooser.addChoosableFileFilter(new DotPltFileFilter());
        chooser.setDialogTitle(this.i18nString("SelectPlotFileTitle", "Select A Plot File"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            this.open(chooser.getSelectedFile());
        } else {
            ((PlotControls)this.ControlPanel_).setStatusBar(this.i18nString("OpenCancelled", "Open file cancelled."));
        }
    }

    public String getAbout() {
        return this.Name_ + " (" + this.Version_ + ") " + this.Info_ + "\nID = \"" + "E1EEQgLss3" + "\"" + "\n" + this.Contact_;
    }

    public Color getCanvasBackground() {
        return ((PlotControls)this.ControlPanel_).getCanvas().getBackground();
    }

    public Color getCanvasForeground() {
        return ((PlotControls)this.ControlPanel_).getCanvas().getForeground();
    }

    protected void initialization(String file_name, boolean help_flag, String date_format, String starting_directory) {
        try {
            ClassLoader cl = Vupos.class.getClassLoader();
            URL url = HelpSet.findHelpSet(cl, "VuposHelp.hs");
            this.HelpSet_ = new HelpSet(cl, url);
            this.HelpBroker_ = this.HelpSet_.createHelpBroker();
        }
        catch (Exception ex) {
            System.out.println("Help Set VuposHelp.hs not found");
        }
        catch (ExceptionInInitializerError eiie) {
            System.err.println("initialization error:");
            eiie.getException().printStackTrace();
        }
        this.initComponents();
        ((PlotControls)this.ControlPanel_).setDateTimeFormat(date_format);
        ((PlotControls)this.ControlPanel_).OpenItemHandler(file_name);
        if (help_flag) {
            try {
                this.HelpBroker_.setCurrentID("vupos.intro");
                this.HelpBroker_.setDisplayed(true);
            }
            catch (Exception be) {
                JOptionPane.showMessageDialog(this, be.toString(), this.i18nString("ErrorDisplayingHelp", "Displaying Help Tool"), 0);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    private void open(File file) {
        if (file != null && file.exists()) {
            String file_name = file.getAbsolutePath();
            this.setPath("PLOT", file_name);
            ((PlotControls)this.ControlPanel_).OpenItemHandler(file_name);
        } else {
            ((PlotControls)this.ControlPanel_).setStatusBar(this.i18nString("SelectPlotFile", "Select a plot file."));
        }
    }

    private void open(String file_name) {
        if (file_name != null && file_name.length() > 0) {
            this.open(new File(file_name));
        } else {
            this.open((File)null);
        }
    }

    public void setCanvasBackground(Color color) {
        ((PlotControls)this.ControlPanel_).getCanvas().setBackground(color);
        this.repaint();
    }

    public void setCanvasForeground(Color color) {
        ((PlotControls)this.ControlPanel_).getCanvas().setForeground(color);
        this.repaint();
    }

    public void setLongDateFormat() {
        ((PlotControls)this.ControlPanel_).setLongDateFormat();
    }

    public void setShortDateFormat() {
        ((PlotControls)this.ControlPanel_).setShortDateFormat();
    }

    public void setStatusBar(String input) {
        ((PlotControls)this.ControlPanel_).setStatusBar(input);
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
    }

    public void setVisible(boolean flag, String file_name) {
        super.setVisible(flag);
        this.open(file_name);
    }

    public void showListHelp() {
        try {
            this.HelpBroker_.setCurrentID("gui.list");
            this.HelpBroker_.setDisplayed(true);
        }
        catch (Exception be) {
            JOptionPane.showMessageDialog(this, be.toString(), this.i18nString("ErrorDisplayingHelp", "Displaying Help Tool"), 0);
        }
    }

    public boolean standsAlone() {
        return this.Parent_ == null;
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        boolean flag = false;
        String file_name = "";
        String format = "YYYY-DDD";
        String directory = ".";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--h") || args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("--help")) {
                flag = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f") || args[i].equalsIgnoreCase("--f") || args[i].equalsIgnoreCase("-format") || args[i].equalsIgnoreCase("--format")) {
                if (++i < args.length) {
                    format = args[i];
                    continue;
                }
                System.err.println("Error: missing format");
                continue;
            }
            if (args[i].equalsIgnoreCase("-d") || args[i].equalsIgnoreCase("--d") || args[i].equalsIgnoreCase("-directory") || args[i].equalsIgnoreCase("--directory")) {
                if (++i < args.length) {
                    directory = args[i];
                    continue;
                }
                System.err.println("Error: missing directory");
                continue;
            }
            if (file_name.length() != 0) continue;
            file_name = args[i];
        }
        final boolean final_flag = flag;
        final String final_name = file_name;
        final String final_format = format;
        final String final_directory = directory;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Vupos plot = new Vupos(final_name, final_flag, final_format, final_directory);
                plot.setSize(800, 560);
                plot.setVisible(true);
            }
        });
    }
}

