/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.GpsTimeZone;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScnFile {
    private int EpochsRead_ = 0;
    private int Ios_ = 0;
    private Matcher Matcher_;
    private SortedSet<Date> Storage_ = new TreeSet<Date>();
    private String FileName_ = "";
    private String Status_ = "";

    public ScnFile() {
    }

    public ScnFile(String name) {
        this.read(name);
    }

    public ScnFile(File file) {
        this.read(file);
    }

    public int read(String name) {
        if (name != null && name.length() > 0) {
            return this.read(new File(name));
        }
        this.Status_ = "No file name was entered.";
        this.Ios_ = 2;
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(File file) {
        this.EpochsRead_ = 0;
        this.Storage_.clear();
        this.Ios_ = 0;
        if (file != null && file.exists()) {
            this.FileName_ = file.getAbsolutePath();
            BufferedReader scn_stream = null;
            try {
                String input;
                scn_stream = new BufferedReader(new FileReader(file));
                while ((input = scn_stream.readLine()) != null) {
                    ++this.EpochsRead_;
                    StringTokenizer tokens = new StringTokenizer(input);
                    if (tokens.countTokens() != 5 && tokens.countTokens() != 6) {
                        this.Status_ = "Incorrect number of values, " + tokens.countTokens() + ", on a line." + "\n\"" + input + "\"";
                        this.Ios_ = 3;
                    }
                    Calendar epoch = Calendar.getInstance((TimeZone)new GpsTimeZone(), Locale.US);
                    int year = Integer.parseInt(tokens.nextToken());
                    if (year < 80) {
                        year += 2000;
                    } else if (year < 100) {
                        year += 1900;
                    }
                    epoch.set(1, year);
                    epoch.set(6, Integer.parseInt(tokens.nextToken()));
                    epoch.set(11, Integer.parseInt(tokens.nextToken()));
                    epoch.set(12, Integer.parseInt(tokens.nextToken()));
                    epoch.set(13, Integer.parseInt(tokens.nextToken()));
                    epoch.set(14, 0);
                    this.Storage_.add(epoch.getTime());
                }
            }
            catch (FileNotFoundException fnfe) {
                this.Status_ = "Unexpected EOF.";
                this.Ios_ = 4;
            }
            catch (IOException ioe) {
                this.Status_ = "I/O error.";
                this.Ios_ = 5;
            }
            finally {
                if (scn_stream != null) {
                    try {
                        scn_stream.close();
                    }
                    catch (IOException ioe) {
                        this.Ios_ = 6;
                    }
                }
                scn_stream = null;
            }
        } else {
            this.Ios_ = -1;
        }
        return this.Ios_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public int getNumberOfEpochs() {
        return this.EpochsRead_;
    }

    public SortedSet<Date> getList() {
        return this.Storage_;
    }

    public String getStatus() {
        return this.Status_;
    }

    public String getName() {
        return this.FileName_;
    }
}

