/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.GpsTime;
import GNSS.GpsTimeZone;
import GPos.Vupos.BreakInstruction;
import GPos.Vupos.EditInstruction;
import GPos.Vupos.KillInstruction;
import GPos.Vupos.PlotCanvas;
import GPos.Vupos.PlotControls;
import GPos.Vupos.PlotTableModel;
import GPos.Vupos.Vupos;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotList
extends JDialog {
    private JButton AllButton_;
    private JButton BreakButton_;
    private JButton ClearButton_;
    private JButton CloseButton_;
    private JButton HelpButton_;
    private JButton KillButton_;
    private JButton SaveButton_;
    private JComboBox SubsetSelection_;
    private JScrollPane TableScrollPane_;
    private JTable Table_;
    private JToolBar ToolBar_;
    private JPanel jPanel1;
    private PlotCanvas Canvas_ = null;
    private ListSelectionModel ListSelectionModel_;
    private PlotTableModel ListTableModel_;
    private Vupos ParentFrame_;
    private PlotControls Parent_;
    private JScrollBar VerBar_;
    private boolean SubsetChange_ = false;
    private boolean ModelChange_ = false;
    private String InputDateFormat_ = "YYYY-DDD";
    private String LastId_ = "";
    private String LastSubset_ = "";
    private boolean NewEditInstructionFormat_ = false;
    private int FirstSelectedRow_ = -1;
    private int HalfRowHeight_ = 1;
    private int LastSelectedRow_ = -1;
    private int LastSet_ = 0;
    private int LastEpoch_ = 0;
    private int RowHeight_ = 1;
    private SortedSet<BreakInstruction> BreakSet_ = new TreeSet<BreakInstruction>();
    private SortedSet<KillInstruction> KillsSet_ = new TreeSet<KillInstruction>();
    private SortedSet<String> SlipsSet_ = new TreeSet<String>();
    private static final Color BreakBG_ = Color.yellow;
    private static final Color KilledFG_ = Color.pink;
    private static final Color NormalBG_ = Color.white;
    private static final Color NormalFG_ = Color.black;
    public static final boolean NEW = true;
    public static final boolean OLD = false;

    public PlotList(Vupos parent_frame, PlotControls parent, boolean modal) {
        this(parent_frame, parent, "YYYY-DDD", modal);
    }

    public PlotList(Vupos parent_frame, PlotControls parent, String date_format, boolean modal) {
        super((Frame)parent_frame, modal);
        this.ParentFrame_ = parent_frame;
        this.Parent_ = parent;
        this.Canvas_ = this.Parent_.getCanvas();
        this.InputDateFormat_ = date_format;
        this.setTitle(this.ParentFrame_.getProgramName());
        this.initComponents();
        this.ListSelectionModel_.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!PlotList.this.ModelChange_) {
                    if (PlotList.this.SubsetChange_) {
                        PlotList.this.Canvas_.draw();
                    } else if (PlotList.this.ListSelectionModel_.isSelectionEmpty()) {
                        PlotList.this.FirstSelectedRow_ = -1;
                        PlotList.this.LastSelectedRow_ = -1;
                        PlotList.this.Canvas_.reticuleAt(PlotList.this.LastEpoch_, true);
                    } else {
                        PlotList.this.Canvas_.reticuleAt(PlotList.this.FirstSelectedRow_ = PlotList.this.ListSelectionModel_.getMinSelectionIndex(), true);
                        PlotList.this.LastSelectedRow_ = PlotList.this.ListSelectionModel_.getMaxSelectionIndex();
                    }
                }
            }
        });
        this.RowHeight_ = this.Table_.getRowHeight();
        this.HalfRowHeight_ = (this.RowHeight_ + 1) / 2;
        this.TableScrollPane_.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                PlotList.this.ListSelectionModel_.clearSelection();
                PlotList.this.Canvas_.reticuleAt(PlotList.this.LastEpoch_ = (evt.getValue() + PlotList.this.HalfRowHeight_) / PlotList.this.RowHeight_);
            }
        });
    }

    private void initComponents() {
        this.BreakButton_ = new JButton();
        this.SubsetSelection_ = new JComboBox();
        this.ToolBar_ = new JToolBar();
        this.CloseButton_ = new JButton();
        this.jPanel1 = new JPanel();
        this.SaveButton_ = new JButton();
        this.KillButton_ = new JButton();
        this.AllButton_ = new JButton();
        this.ClearButton_ = new JButton();
        this.HelpButton_ = new JButton();
        this.TableScrollPane_ = new JScrollPane();
        this.ListTableModel_ = new PlotTableModel();
        this.Table_ = new JTable();
        this.ListSelectionModel_ = this.Table_.getSelectionModel();
        this.ListSelectionModel_.setSelectionMode(1);
        this.BreakButton_.setMnemonic(this.Parent_.i18nString("BreakButtonLabelMnemonic", "B").charAt(0));
        this.BreakButton_.setText(this.Parent_.i18nString("BreakButtonLabel", "Break"));
        this.BreakButton_.setToolTipText(this.Parent_.i18nString("BreakButtonLabelToolTip", "Force a new phase ambiguity."));
        this.BreakButton_.setMargin(new Insets(2, 2, 2, 2));
        this.BreakButton_.setMinimumSize(new Dimension(60, 25));
        this.BreakButton_.setPreferredSize(new Dimension(60, 25));
        this.BreakButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.BreakButton_ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                PlotList.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                PlotList.this.formWindowOpened(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent evt) {
                PlotList.this.formComponentHidden(evt);
            }

            public void componentShown(ComponentEvent evt) {
                PlotList.this.formComponentShown(evt);
            }
        });
        this.SubsetSelection_.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.SubsetSelection_.setToolTipText("Select a data subset.");
        this.SubsetSelection_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.SubsetSelection_ActionPerformed(evt);
            }
        });
        this.ToolBar_.setFloatable(false);
        this.CloseButton_.setMnemonic(this.Parent_.i18nString("CloseMnemonic", "C").charAt(0));
        this.CloseButton_.setText(this.Parent_.i18nString("Close", "Close"));
        this.CloseButton_.setToolTipText(this.Parent_.i18nString("CloseToolTip", "Close this window."));
        this.CloseButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.CloseButton_ActionPerformed(evt);
            }
        });
        this.ToolBar_.add(this.CloseButton_);
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.ToolBar_.add(Box.createHorizontalGlue());
        this.SaveButton_.setMnemonic(this.Parent_.i18nString("SaveMnemonic", "S").charAt(0));
        this.SaveButton_.setText(this.Parent_.i18nString("Save", "Save"));
        this.SaveButton_.setToolTipText(this.Parent_.i18nString("SaveToolTip", "Save edit instructions."));
        this.SaveButton_.setEnabled(false);
        this.SaveButton_.setMargin(new Insets(2, 2, 2, 2));
        this.SaveButton_.setMinimumSize(new Dimension(60, 25));
        this.SaveButton_.setPreferredSize(new Dimension(60, 25));
        this.SaveButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.SaveButton_ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.SaveButton_);
        this.KillButton_.setMnemonic(this.Parent_.i18nString("KillButtonLabelMnemonic", "K").charAt(0));
        this.KillButton_.setText(this.Parent_.i18nString("KillButtonLabel", "Kill"));
        this.KillButton_.setToolTipText(this.Parent_.i18nString("KillButtonLabelToolTip", "Flag indicated data for omission."));
        this.KillButton_.setEnabled(false);
        this.KillButton_.setMargin(new Insets(2, 2, 2, 2));
        this.KillButton_.setMinimumSize(new Dimension(60, 25));
        this.KillButton_.setPreferredSize(new Dimension(60, 25));
        this.KillButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.KillButton_ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.KillButton_);
        this.AllButton_.setMnemonic(this.Parent_.i18nString("KillAllButtonLabelMnemonic", "A").charAt(0));
        this.AllButton_.setText(this.Parent_.i18nString("KillAllButtonLabel", "Kill All"));
        this.AllButton_.setToolTipText(this.Parent_.i18nString("KillAllButtonLabelToolTip", "Flag indicated data for all satellites for omission."));
        this.AllButton_.setMargin(new Insets(2, 2, 2, 2));
        this.AllButton_.setMinimumSize(new Dimension(60, 25));
        this.AllButton_.setPreferredSize(new Dimension(60, 25));
        this.AllButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.AllButton_ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.AllButton_);
        this.ClearButton_.setMnemonic(this.Parent_.i18nString("ClearButtonLabelMnemonic", "L").charAt(0));
        this.ClearButton_.setText(this.Parent_.i18nString("ClearButtonLabel", "Clear"));
        this.ClearButton_.setToolTipText(this.Parent_.i18nString("ClearButtonLabelToolTip", "Clear all edit instructions."));
        this.ClearButton_.setEnabled(false);
        this.ClearButton_.setMargin(new Insets(2, 2, 2, 2));
        this.ClearButton_.setMinimumSize(new Dimension(60, 25));
        this.ClearButton_.setPreferredSize(new Dimension(60, 25));
        this.ClearButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.ClearButton_ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.ClearButton_);
        this.ToolBar_.add(this.jPanel1);
        this.ToolBar_.add(Box.createHorizontalGlue());
        this.HelpButton_.setMnemonic(this.Parent_.i18nString("HelpMnemonic", "H").charAt(0));
        this.HelpButton_.setText(this.Parent_.i18nString("Help", "Help"));
        this.HelpButton_.setToolTipText(this.Parent_.i18nString("HelpItemToolTip", "Display the list's help information."));
        this.HelpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotList.this.HelpButton_ActionPerformed(evt);
            }
        });
        this.ToolBar_.add(this.HelpButton_);
        this.TableScrollPane_.setPreferredSize(new Dimension(500, 403));
        this.Table_.setFont(new Font("Monospaced", 1, 12));
        this.Table_.setModel(this.ListTableModel_);
        this.Table_.setSelectionModel(this.Table_.getSelectionModel());
        this.TableScrollPane_.setViewportView(this.Table_);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, this.SubsetSelection_, 0, 452, Short.MAX_VALUE).add(2, this.ToolBar_, -1, 452, Short.MAX_VALUE).add(2, this.TableScrollPane_, -1, 452, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.SubsetSelection_, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.TableScrollPane_, -2, 247, -2).addPreferredGap(0).add(this.ToolBar_, -2, 25, -2)));
        this.pack();
    }

    private void AllButton_ActionPerformed(ActionEvent evt) {
        this.allKill();
        this.ListSelectionModel_.clearSelection();
    }

    private void CloseButton_ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void HelpButton_ActionPerformed(ActionEvent evt) {
        this.Parent_.showListHelp();
    }

    private void ClearButton_ActionPerformed(ActionEvent evt) {
        int n;
        if ((this.BreakSet_.size() > 0 || this.KillsSet_.size() > 0 || this.SlipsSet_.size() > 0) && (n = JOptionPane.showConfirmDialog(this.Parent_, "Clear input edit instructions?", "Clear edit instructions", 0)) == 0) {
            this.clearEdits();
            this.Parent_.deleteBrkFile();
            this.Parent_.deleteEdtFile();
            this.ListTableModel_.fireTableDataChanged();
        }
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.Canvas_.reticuleOff();
    }

    private void KillButton_ActionPerformed(ActionEvent evt) {
        this.addKill();
        this.ListSelectionModel_.clearSelection();
    }

    private void BreakButton_ActionPerformed(ActionEvent evt) {
        this.addBreak();
        this.ListSelectionModel_.clearSelection();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.Canvas_.reticuleOn(this.LastEpoch_);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.Canvas_.reticuleOn(this.LastEpoch_);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.Canvas_.reticuleOff();
    }

    private void SubsetSelection_ActionPerformed(ActionEvent evt) {
        String tmp = (String)this.SubsetSelection_.getSelectedItem();
        if (this.SubsetSelection_.getSelectedIndex() >= 0 && tmp != null && tmp.compareTo(this.LastSubset_) != 0) {
            this.SubsetChange_ = true;
            this.LastSubset_ = tmp;
            this.LastId_ = tmp.substring(0, 3).trim();
            this.ListTableModel_.useDataSet(this.LastId_);
            if (this.FirstSelectedRow_ >= 0) {
                this.ListSelectionModel_.setSelectionInterval(this.FirstSelectedRow_, this.FirstSelectedRow_);
            }
            this.repaint();
            this.Canvas_.reticuleAt(this.LastEpoch_, true);
            this.SubsetChange_ = false;
        }
    }

    private void SaveButton_ActionPerformed(ActionEvent evt) {
        if (!this.NewEditInstructionFormat_) {
            this.Parent_.saveBreakInstructions();
        }
        this.Parent_.saveKillInstructions();
    }

    public void addBreak() {
        if (this.FirstSelectedRow_ != -1) {
            BreakInstruction instruction = new BreakInstruction((String)this.SubsetSelection_.getSelectedItem(), 1, this.FirstSelectedRow_ + 1, (Date)this.ListTableModel_.getValueAt(this.FirstSelectedRow_, 1));
            if (this.BreakSet_.contains(instruction)) {
                Object[] options = new Object[]{"OK", "Delete"};
                int n = JOptionPane.showOptionDialog(this.Parent_, "A break instruction exists for " + (String)this.SubsetSelection_.getSelectedItem() + " at point " + Integer.toString(this.FirstSelectedRow_ + 1) + ".", "Edit instruction exists", 0, 3, null, options, options[0]);
                if (n == 1) {
                    this.Parent_.setStatusBar("Remove break for " + (String)this.SubsetSelection_.getSelectedItem() + " at " + (this.FirstSelectedRow_ + 1) + ".");
                    this.BreakSet_.remove(instruction);
                } else {
                    this.Parent_.clearStatusBar();
                }
            } else {
                this.Parent_.setStatusBar("Add break for " + (String)this.SubsetSelection_.getSelectedItem() + " at " + (this.FirstSelectedRow_ + 1) + ".");
                this.BreakSet_.add(instruction);
            }
        } else {
            JOptionPane.showMessageDialog(this.Parent_, "No data point has been selected.", "Break error", 0);
        }
    }

    public void addKill() {
        if (this.FirstSelectedRow_ != -1) {
            this.Parent_.clearStatusBar();
            KillInstruction instruction = this.NewEditInstructionFormat_ ? new KillInstruction((String)this.SubsetSelection_.getSelectedItem(), 1, 1, this.FirstSelectedRow_ + 1, this.LastSelectedRow_ + 1, (Date)this.ListTableModel_.getValueAt(this.FirstSelectedRow_, 1), (Date)this.ListTableModel_.getValueAt(this.LastSelectedRow_, 1)) : new KillInstruction((String)this.SubsetSelection_.getSelectedItem(), 1, 1, this.FirstSelectedRow_ + 1, this.LastSelectedRow_ + 1, (Date)this.ListTableModel_.getValueAt(this.FirstSelectedRow_, 1));
            if (this.KillsSet_.contains(instruction)) {
                Object[] options = new Object[]{"OK", "Delete"};
                int n = JOptionPane.showOptionDialog(this.Parent_, "A kill instruction exists for " + (String)this.SubsetSelection_.getSelectedItem() + " at point " + Integer.toString(this.FirstSelectedRow_ + 1) + ".", "Edit instruction exists", 0, 3, null, options, options[0]);
                if (n == 1) {
                    this.Parent_.setStatusBar("Remove kill " + (String)this.SubsetSelection_.getSelectedItem() + " from " + (this.FirstSelectedRow_ + 1) + " to " + (this.LastSelectedRow_ + 1) + ".");
                    this.KillsSet_.remove(instruction);
                } else {
                    this.Parent_.clearStatusBar();
                }
            } else {
                this.Parent_.setStatusBar("Add kill " + (String)this.SubsetSelection_.getSelectedItem() + " from " + (this.FirstSelectedRow_ + 1) + " to " + (this.LastSelectedRow_ + 1) + ".");
                this.KillsSet_.add(instruction);
            }
            this.FirstSelectedRow_ = -1;
            this.LastSelectedRow_ = -1;
        } else {
            JOptionPane.showMessageDialog(this.Parent_, "No data point has been selected.", "Kill error", 0);
        }
    }

    public void addItem(int sequence_number, String input) {
        this.SubsetSelection_.addItem(input);
    }

    public void allKill() {
        boolean flag = false;
        int response = 1;
        if (this.FirstSelectedRow_ != -1) {
            this.Parent_.clearStatusBar();
            KillInstruction instruction = this.NewEditInstructionFormat_ ? new KillInstruction(EditInstruction.getAllId(), 1, 1, this.FirstSelectedRow_ + 1, this.LastSelectedRow_ + 1, (Date)this.ListTableModel_.getValueAt(this.FirstSelectedRow_, 1), (Date)this.ListTableModel_.getValueAt(this.LastSelectedRow_, 1)) : new KillInstruction(EditInstruction.getAllId(), 1, 1, this.FirstSelectedRow_ + 1, this.LastSelectedRow_ + 1, (Date)this.ListTableModel_.getValueAt(this.FirstSelectedRow_, 1));
            if (this.KillsSet_.contains(instruction)) {
                if (!flag) {
                    Object[] options = new Object[]{"OK", "Delete"};
                    response = JOptionPane.showOptionDialog(this.Parent_, "A kill instruction exists at point " + Integer.toString(this.FirstSelectedRow_ + 1) + ".", "Edit instruction exists", 0, 3, null, options, options[0]);
                    flag = true;
                }
                if (response == 1) {
                    this.Parent_.setStatusBar("Remove kill " + EditInstruction.getAllId() + " from " + (this.FirstSelectedRow_ + 1) + " to " + (this.LastSelectedRow_ + 1) + ".");
                    this.KillsSet_.remove(instruction);
                } else {
                    this.Parent_.clearStatusBar();
                }
            } else {
                if (!flag) {
                    this.Parent_.setStatusBar("Add kill all SVs from " + (this.FirstSelectedRow_ + 1) + " to " + (this.LastSelectedRow_ + 1) + ".");
                    flag = true;
                }
                this.KillsSet_.add(instruction);
            }
            this.FirstSelectedRow_ = -1;
            this.LastSelectedRow_ = -1;
        } else {
            JOptionPane.showMessageDialog(this.Parent_, "No data point has been selected.", "Kill error", 0);
        }
    }

    public void clearEdits() {
        this.BreakSet_.clear();
        this.KillsSet_.clear();
        this.SlipsSet_.clear();
    }

    public Iterator<BreakInstruction> getBreakIterator() {
        return this.BreakSet_.iterator();
    }

    public String getCurrentId() {
        return this.LastId_;
    }

    public String getCurrentSelection() {
        return this.LastSubset_;
    }

    public boolean getEditInstructionFormat() {
        return this.NewEditInstructionFormat_;
    }

    public Iterator<KillInstruction> getKillsIterator() {
        return this.KillsSet_.iterator();
    }

    public boolean hasBreaks() {
        return !this.BreakSet_.isEmpty();
    }

    public boolean hasEdits() {
        return !this.BreakSet_.isEmpty() || !this.KillsSet_.isEmpty() || !this.SlipsSet_.isEmpty();
    }

    public boolean hasKills() {
        return !this.KillsSet_.isEmpty();
    }

    public boolean hasSlips() {
        return !this.SlipsSet_.isEmpty();
    }

    private void initColumnSizes() {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        Object[] longValues = this.ListTableModel_.longValues;
        TableCellRenderer headerRenderer = this.Table_.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < this.ListTableModel_.getColumnCount(); ++i) {
            column = this.Table_.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = this.Table_.getDefaultRenderer(this.ListTableModel_.getColumnClass(i)).getTableCellRendererComponent(this.Table_, longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(StrictMath.max(headerWidth, cellWidth));
        }
    }

    public boolean isBreak(String id, int station, int point) {
        Iterator<BreakInstruction> itr = this.getBreakIterator();
        while (itr.hasNext()) {
            BreakInstruction instruction = itr.next();
            if (!instruction.isBreak(id, station, point) && !instruction.isBreak(EditInstruction.getAllId(), station, point)) continue;
            return true;
        }
        return false;
    }

    public boolean isKilled(String id, int station, int frequency, int point) {
        Iterator<KillInstruction> itr = this.getKillsIterator();
        while (itr.hasNext()) {
            KillInstruction instruction = itr.next();
            if (!instruction.isKilled(id, station, frequency, point) && !instruction.isKilled(EditInstruction.getAllId(), station, frequency, point)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotBreak(String id, int station, int point) {
        return !this.isBreak(id, station, point);
    }

    public boolean isNotKilled(String id, int station, int frequency, int point) {
        return !this.isKilled(id, station, frequency, point);
    }

    public void removeAllItems() {
        this.SubsetSelection_.removeAllItems();
        this.LastId_ = "";
        this.LastSubset_ = "";
    }

    public void resetModel() {
        this.SubsetSelection_.setEnabled(false);
        this.SaveButton_.setEnabled(false);
        this.BreakButton_.setEnabled(false);
        this.KillButton_.setEnabled(false);
        this.ClearButton_.setEnabled(false);
    }

    public void setModel(PlotTableModel input) {
        this.ModelChange_ = true;
        this.ListTableModel_ = input;
        this.LastSet_ = 0;
        this.LastId_ = "";
        this.LastSubset_ = "";
        this.LastEpoch_ = 0;
        this.Table_.setModel(this.ListTableModel_);
        this.Table_.getColumnModel().getColumn(0).setCellRenderer(new ListIntegerRenderer(this));
        if (this.ListTableModel_.getColumnObject(1) instanceof Date) {
            this.Table_.getColumnModel().getColumn(1).setCellRenderer(new ListDateRenderer(this, this.InputDateFormat_));
        } else {
            this.Table_.getColumnModel().getColumn(1).setCellRenderer(new ListDoubleRenderer(this));
        }
        if (this.ListTableModel_.getColumnObject(2) instanceof Date) {
            this.Table_.getColumnModel().getColumn(2).setCellRenderer(new ListDateRenderer(this, this.InputDateFormat_));
        } else {
            this.Table_.getColumnModel().getColumn(2).setCellRenderer(new ListDoubleRenderer(this));
        }
        this.initColumnSizes();
        this.ModelChange_ = false;
        this.SubsetSelection_.setEnabled(true);
        if (this.Parent_.getPlotType().equalsIgnoreCase("OMNI")) {
            this.SaveButton_.setEnabled(true);
            this.BreakButton_.setEnabled(true);
            this.KillButton_.setEnabled(true);
            this.ClearButton_.setEnabled(true);
        } else {
            this.SaveButton_.setEnabled(false);
            this.BreakButton_.setEnabled(false);
            this.KillButton_.setEnabled(false);
            this.ClearButton_.setEnabled(false);
        }
    }

    public void setModel(int input) {
        if (input != this.LastSet_) {
            this.LastSet_ = input;
            this.ListTableModel_.useDataSet(this.LastSet_);
            this.repaint();
            this.Canvas_.reticuleAt(this.LastEpoch_, true);
        }
    }

    public void setDateFormat(String input) {
        ListDateRenderer tmp;
        this.InputDateFormat_ = input;
        boolean flag = false;
        if (this.ListTableModel_.getColumnObject(1) instanceof Date && (tmp = (ListDateRenderer)this.Table_.getColumnModel().getColumn(1).getCellRenderer()) != null) {
            tmp.setDateFormat(input);
            flag = true;
        }
        if (this.ListTableModel_.getColumnObject(2) instanceof Date && (tmp = (ListDateRenderer)this.Table_.getColumnModel().getColumn(2).getCellRenderer()) != null) {
            tmp.setDateFormat(input);
            flag = true;
        }
        if (flag) {
            this.ListTableModel_.fireTableDataChanged();
        }
    }

    public void setEditInstructionFormat(boolean input) {
        this.NewEditInstructionFormat_ = input;
        this.BreakButton_.setEnabled(!input);
    }

    public void setTimeFormat(String input) {
    }

    static class ListIntegerRenderer
    extends DefaultTableCellRenderer {
        private PlotList Parent_ = null;

        public ListIntegerRenderer(PlotList parent) {
            this.Parent_ = parent;
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (cell.isVisible() && !isSelected && !hasFocus) {
                if (this.Parent_.isKilled(this.Parent_.getCurrentId(), 1, 1, row + 1)) {
                    cell.setForeground(KilledFG_);
                } else {
                    cell.setForeground(NormalFG_);
                }
                if (this.Parent_.isBreak(this.Parent_.getCurrentId(), 1, row + 1)) {
                    cell.setBackground(BreakBG_);
                } else {
                    cell.setBackground(NormalBG_);
                }
            }
            return cell;
        }
    }

    static class ListDoubleRenderer
    extends DefaultTableCellRenderer {
        public static DecimalFormat DF0_ = new DecimalFormat("  0.00000###; -0.00000###");
        public static DecimalFormat DF1_ = new DecimalFormat("  0.00000E0; -0.00000E0");
        private PlotList Parent_ = null;

        public ListDoubleRenderer(PlotList parent) {
            this.Parent_ = parent;
        }

        public void setValue(Object value) {
            this.setText(value == null ? "  ---------" : (StrictMath.abs((Double)value) > 1000.0 || StrictMath.abs((Double)value) < 0.001 ? DF1_.format(value) : DF0_.format(value)));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (cell.isVisible() && !isSelected && !hasFocus) {
                if (this.Parent_.isKilled(this.Parent_.getCurrentId(), 1, 1, row + 1)) {
                    cell.setForeground(KilledFG_);
                } else {
                    cell.setForeground(NormalFG_);
                }
                if (this.Parent_.isBreak(this.Parent_.getCurrentId(), 1, row + 1)) {
                    cell.setBackground(BreakBG_);
                } else {
                    cell.setBackground(NormalBG_);
                }
            }
            return cell;
        }
    }

    static class ListDateRenderer
    extends DefaultTableCellRenderer {
        public static SimpleDateFormat DF_ = new SimpleDateFormat(" HH:mm:ss.SSS");
        private GpsTime Epoch_ = new GpsTime();
        private String InputDateFormat_ = "YYYY-DDD";
        private PlotList Parent_ = null;

        public ListDateRenderer(PlotList parent) {
            this.Parent_ = parent;
            DF_.setTimeZone((TimeZone)new GpsTimeZone());
            this.InputDateFormat_ = "YYYY-DDD";
        }

        public ListDateRenderer(PlotList parent, String format) {
            this.Parent_ = parent;
            DF_.setTimeZone((TimeZone)new GpsTimeZone());
            this.InputDateFormat_ = format;
        }

        private String getDateString(Object input) {
            this.Epoch_.setTime((Date)input);
            if (this.InputDateFormat_.equalsIgnoreCase("MJD")) {
                return "     " + this.Epoch_.toMjdString();
            }
            if (this.InputDateFormat_.equalsIgnoreCase("SINEX")) {
                return "    " + this.Epoch_.toSinexDateString();
            }
            if (this.InputDateFormat_.equalsIgnoreCase("YYYY-DDD")) {
                return "  " + this.Epoch_.toIsoYdString();
            }
            if (this.InputDateFormat_.equalsIgnoreCase("YYYY-MM-DD")) {
                return this.Epoch_.toIsoYmdString();
            }
            return "  " + this.Epoch_.toIsoYdString();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (cell.isVisible() && !isSelected && !hasFocus) {
                if (this.Parent_.isKilled(this.Parent_.getCurrentId(), 1, 1, row + 1)) {
                    cell.setForeground(KilledFG_);
                } else {
                    cell.setForeground(NormalFG_);
                }
                if (this.Parent_.isBreak(this.Parent_.getCurrentId(), 1, row + 1)) {
                    cell.setBackground(BreakBG_);
                } else {
                    cell.setBackground(NormalBG_);
                }
            }
            return cell;
        }

        public void setDateFormat(String input) {
            this.InputDateFormat_ = input;
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : this.getDateString(value) + DF_.format(value));
        }
    }
}

