/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.RinexGnsId;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class PlotGnsInfo {
    private static final String[] Symbols_ = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private boolean Visible_ = true;
    private int Index_ = -1;
    private int LastX_ = -100;
    private int LastY_ = -100;
    private int XOff_ = -1;
    private int XWidth_ = 3;
    private int YOff_ = -1;
    private int YWidth_ = 3;
    private Color Color_ = Color.BLACK;
    private Polygon Shape_;

    PlotGnsInfo(String symbol) {
        this.setSymbol(symbol);
    }

    PlotGnsInfo(String symbol, Color color) {
        this.setSymbol(symbol);
        this.Color_ = color;
    }

    PlotGnsInfo(int symbol) {
        this.setSymbol(symbol);
    }

    PlotGnsInfo(int symbol, Color color) {
        this.setSymbol(symbol);
        this.Color_ = color;
    }

    public void draw(Graphics page, int x, int y) {
        if (this.Visible_) {
            this.draw(page, x, y, this.Color_);
        }
    }

    public void draw(Graphics page, int x, int y, Color color) {
        if (this.Visible_) {
            Color saved_color = page.getColor();
            page.setColor(color);
            if (StrictMath.abs(x - this.LastX_) > this.XWidth_ || StrictMath.abs(y - this.LastY_) > this.YWidth_) {
                switch (this.Index_) {
                    case -7: {
                        this.Shape_.translate(x, y);
                        page.fillPolygon(this.Shape_);
                        this.Shape_.translate(-x, -y);
                        break;
                    }
                    case -6: {
                        this.Shape_.translate(x, y);
                        page.fillPolygon(this.Shape_);
                        this.Shape_.translate(-x, -y);
                        break;
                    }
                    case -5: {
                        this.Shape_.translate(x, y);
                        page.fillPolygon(this.Shape_);
                        this.Shape_.translate(-x, -y);
                        break;
                    }
                    case -4: {
                        this.Shape_.translate(x, y);
                        page.fillPolygon(this.Shape_);
                        this.Shape_.translate(-x, -y);
                        break;
                    }
                    case -3: {
                        this.Shape_.translate(x, y);
                        page.fillPolygon(this.Shape_);
                        this.Shape_.translate(-x, -y);
                        break;
                    }
                    case -2: {
                        page.fillOval(x + this.XOff_, y + this.YOff_, this.XWidth_, this.YWidth_);
                        break;
                    }
                    case -1: {
                        page.fillRect(x + this.XOff_, y + this.YOff_, this.XWidth_, this.YWidth_);
                        break;
                    }
                    default: {
                        page.drawString(Symbols_[this.Index_], x + this.XOff_, y + this.YOff_);
                    }
                }
                this.LastX_ = x;
                this.LastY_ = y;
            } else {
                page.fillRect(x - 1, y - 1, 3, 3);
            }
            page.setColor(saved_color);
        }
    }

    public String getSymbol() {
        switch (this.Index_) {
            case -7: {
                return "rtriangle";
            }
            case -6: {
                return "ltriangle";
            }
            case -5: {
                return "dtriangle";
            }
            case -4: {
                return "utriangle";
            }
            case -3: {
                return "diamond";
            }
            case -2: {
                return "circle";
            }
            case -1: {
                return "square";
            }
        }
        return Symbols_[this.Index_];
    }

    public static String getSymbol(String input) {
        return Symbols_[(RinexGnsId.getIndex((String)input) - 1) % Symbols_.length];
    }

    public void hide() {
        this.Visible_ = false;
    }

    public boolean isVisible() {
        return this.Visible_;
    }

    public void reset(Graphics page) {
        FontMetrics font_metrics = page.getFontMetrics();
        this.reset(font_metrics);
    }

    public void reset(FontMetrics metrics) {
        this.LastY_ = -100;
        this.LastX_ = -100;
        this.XWidth_ = this.YWidth_ = metrics.getHeight();
        this.XOff_ = this.YOff_ = -(this.XWidth_ + 1) / 2;
        switch (this.Index_) {
            case -2: 
            case -1: {
                break;
            }
            case -3: {
                this.Shape_.reset();
                this.Shape_.addPoint(0, this.YOff_);
                this.Shape_.addPoint(-this.XOff_, 0);
                this.Shape_.addPoint(0, -this.YOff_);
                this.Shape_.addPoint(this.XOff_, 0);
                break;
            }
            case -4: {
                this.Shape_.reset();
                this.Shape_.addPoint(0, this.YOff_);
                this.Shape_.addPoint(-this.XOff_, -this.YOff_);
                this.Shape_.addPoint(this.XOff_, -this.YOff_);
                break;
            }
            case -5: {
                this.Shape_.reset();
                this.Shape_.addPoint(0, -this.YOff_);
                this.Shape_.addPoint(-this.XOff_, this.YOff_);
                this.Shape_.addPoint(this.XOff_, this.YOff_);
                break;
            }
            case -6: {
                this.Shape_.reset();
                this.Shape_.addPoint(this.XOff_, 0);
                this.Shape_.addPoint(-this.XOff_, this.YOff_);
                this.Shape_.addPoint(-this.XOff_, -this.YOff_);
                break;
            }
            case -7: {
                this.Shape_.reset();
                this.Shape_.addPoint(-this.XOff_, 0);
                this.Shape_.addPoint(this.XOff_, this.YOff_);
                this.Shape_.addPoint(this.XOff_, -this.YOff_);
                break;
            }
            default: {
                int leading = metrics.getLeading();
                this.XWidth_ = metrics.charWidth(Symbols_[this.Index_].charAt(0));
                this.XOff_ = -(this.XWidth_ - 1) / 2 + leading;
                this.YOff_ = (this.YWidth_ + 1) / 2 - metrics.getDescent() - leading;
            }
        }
    }

    public void reset(int size) {
        this.LastY_ = -100;
        this.LastX_ = -100;
        this.XWidth_ = this.YWidth_ = size;
        this.XOff_ = this.YOff_ = -(this.XWidth_ + 1) / 2;
        switch (this.Index_) {
            case -3: {
                this.Shape_.reset();
                this.Shape_.addPoint(0, this.YOff_);
                this.Shape_.addPoint(-this.XOff_, 0);
                this.Shape_.addPoint(0, -this.YOff_);
                this.Shape_.addPoint(this.XOff_, 0);
                break;
            }
            case -4: {
                this.Shape_.reset();
                this.Shape_.addPoint(0, this.YOff_);
                this.Shape_.addPoint(-this.XOff_, -this.YOff_);
                this.Shape_.addPoint(this.XOff_, -this.YOff_);
                break;
            }
            case -5: {
                this.Shape_.reset();
                this.Shape_.addPoint(0, -this.YOff_);
                this.Shape_.addPoint(-this.XOff_, this.YOff_);
                this.Shape_.addPoint(this.XOff_, this.YOff_);
                break;
            }
            case -6: {
                this.Shape_.reset();
                this.Shape_.addPoint(this.XOff_, 0);
                this.Shape_.addPoint(-this.XOff_, this.YOff_);
                this.Shape_.addPoint(-this.XOff_, -this.YOff_);
                break;
            }
            case -7: {
                this.Shape_.reset();
                this.Shape_.addPoint(-this.XOff_, 0);
                this.Shape_.addPoint(this.XOff_, this.YOff_);
                this.Shape_.addPoint(this.XOff_, -this.YOff_);
            }
        }
    }

    public void setColor(Color color) {
        this.Color_ = color;
    }

    public void setSymbol(String input) {
        if (input.equalsIgnoreCase("square")) {
            this.Index_ = -1;
        } else if (input.equalsIgnoreCase("circle")) {
            this.Index_ = -2;
        } else if (input.equalsIgnoreCase("diamond")) {
            this.Index_ = -3;
            this.Shape_ = new Polygon();
        } else if (input.equalsIgnoreCase("utriangle") || input.equalsIgnoreCase("triangle")) {
            this.Index_ = -4;
            this.Shape_ = new Polygon();
        } else if (input.equalsIgnoreCase("dtriangle")) {
            this.Index_ = -5;
            this.Shape_ = new Polygon();
        } else if (input.equalsIgnoreCase("ltriangle")) {
            this.Index_ = -6;
            this.Shape_ = new Polygon();
        } else if (input.equalsIgnoreCase("rtriangle")) {
            this.Index_ = -7;
            this.Shape_ = new Polygon();
        } else {
            try {
                this.Index_ = (RinexGnsId.getIndex((String)input) - 1) % Symbols_.length;
            }
            catch (IllegalArgumentException e) {
                this.Index_ = -1;
            }
        }
    }

    public void setSymbol(int input) {
        if (input >= -7 && input >= -3) {
            this.Index_ = input;
            this.Shape_ = new Polygon();
        } else {
            this.Index_ = input <= Symbols_.length ? input : -1;
        }
    }

    public void setVisible() {
        this.Visible_ = true;
    }

    public void setVisible(boolean input) {
        this.Visible_ = input;
    }

    public void show() {
        this.Visible_ = true;
    }
}

