/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.GpsTimeZone;
import GNSS.RinexGnsId;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotFile {
    private int EpochsRead_ = 0;
    private int Ios_ = 0;
    private int nFrequencies_;
    private int nPlots_;
    private int nStations_;
    private long CharRead_ = 0L;
    private long FileLength_ = 0L;
    private BufferedReader FileStream_;
    private ArrayList<String> Types_ = new ArrayList();
    private ArrayList<String> Title_ = new ArrayList();
    private ArrayList<Object> YMax_ = new ArrayList();
    private ArrayList<Object> YMin_ = new ArrayList();
    private Calendar Epoch_ = Calendar.getInstance((TimeZone)new GpsTimeZone(), Locale.US);
    private DecimalFormat YName_ = new DecimalFormat("Y00");
    private File File_ = null;
    private Matcher Matcher_;
    private Object XMax_;
    private Object XMin_;
    private Pattern DatePattern_ = Pattern.compile("[12][09][0-9][0-9]-[ 01][0-9]-[ 0123][0-9]");
    private Pattern TimePattern_ = Pattern.compile("[ 0-2][0-9]:[ 0-6][0-9]:[ 0-6][0-9]");
    private Pattern FullPattern_ = Pattern.compile("[12][09][0-9][0-9]-[ 01][0-9]-[ 0123][0-9][T ][ 0-2][0-9]:[ 0-6][0-9]:[ 0-6][0-9]");
    private Pattern NumbPattern_ = Pattern.compile("[+\\-]?\\d+(\\.\\d+)");
    private Pattern OmniEpochFormat_ = Pattern.compile("^\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)?(\\.\\d*)?\\s*([\\s\\d]\\d.*)");
    private Pattern Separators_ = Pattern.compile("[T \\t\\-\\:\\/]+");
    private SimpleDateFormat DateFormat_ = new SimpleDateFormat("yyyy MM dd");
    private SimpleDateFormat FullFormat_ = new SimpleDateFormat("yyyy MM dd HH mm ss");
    private SimpleDateFormat TimeFormat_ = new SimpleDateFormat("HH mm ss");
    private SortedSet<String> GnsList_ = new TreeSet<String>();
    private String FileFormat_ = "";
    private String FileName_ = "";
    private String FullName_ = "";
    private String Status_ = "";
    private String XAxisLabel_;
    private String YAxisLabel_;
    private static final double EDIT = -9999.0;
    private static final double EPS = 0.001;

    public PlotFile() {
        this.DateFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.FullFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.TimeFormat_.setTimeZone((TimeZone)new GpsTimeZone());
    }

    public PlotFile(String name) {
        this.DateFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.FullFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.TimeFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.openPlot(name);
    }

    public PlotFile(File file) {
        this.openPlot(file);
    }

    public int openPlot(String name) {
        try {
            return this.openPlot(new File(name));
        }
        catch (NullPointerException npe) {
            this.Status_ = "No file name was entered.";
            this.Ios_ = 1;
            return 1;
        }
    }

    public int openPlot(File file) {
        this.File_ = file;
        this.FileLength_ = file.length();
        this.FileName_ = file.getName();
        try {
            this.FullName_ = file.getCanonicalPath();
        }
        catch (IOException ex) {
            this.FullName_ = file.getAbsolutePath();
        }
        this.CharRead_ = 0L;
        this.EpochsRead_ = 0;
        this.nFrequencies_ = 0;
        this.nPlots_ = 0;
        this.nStations_ = 0;
        this.XMax_ = null;
        this.XMin_ = null;
        this.YMax_.clear();
        this.YMin_.clear();
        this.Ios_ = 0;
        try {
            this.FileStream_ = new BufferedReader(new FileReader(this.File_), 10240);
        }
        catch (IOException ioe) {
            this.Status_ = ioe.getMessage() + " OPENING \"" + this.File_.toString() + "\"";
            this.Ios_ = 101;
        }
        return this.Ios_;
    }

    public int getFileFormat() {
        this.FileFormat_ = null;
        this.Ios_ = this.readOmniPlotHeader();
        if (this.Ios_ == 0) {
            this.FileFormat_ = "OMNI";
        } else {
            this.Ios_ = this.testXY();
            if (this.Ios_ == 0) {
                this.FileFormat_ = "XY";
            }
        }
        return this.Ios_;
    }

    public int closePlot() {
        if (this.Ios_ == 0) {
            try {
                this.FileStream_.close();
                this.FileStream_ = null;
            }
            catch (IOException ioe) {
                this.Status_ = ioe.getMessage() + " CLOSING \"" + this.File_.toString() + "\"";
                this.Ios_ = 201;
            }
        }
        return this.Ios_;
    }

    public String getAbsolutePath() {
        return this.FullName_;
    }

    public int getIos() {
        return this.Ios_;
    }

    public String getName() {
        return this.FileName_;
    }

    public String getPath() {
        return this.File_.getPath();
    }

    public Object getXMax() {
        return this.XMax_;
    }

    public Object getYMax(int index) {
        return index < this.YMax_.size() ? this.YMax_.get(index) : Double.valueOf(0.0);
    }

    public Object getXMin() {
        return this.XMin_;
    }

    public Object getYMin(int index) {
        return index < this.YMin_.size() ? this.YMin_.get(index) : Double.valueOf(0.0);
    }

    public int getNumberOfEpochs() {
        return this.EpochsRead_;
    }

    public int getNumberOfFrequencies() {
        return this.nFrequencies_;
    }

    public int getNumberOfPlots() {
        return this.nPlots_;
    }

    public int getNumberOfSatellites() {
        return this.GnsList_.size();
    }

    public int getNumberOfStations() {
        return this.nStations_;
    }

    public SortedSet<String> getSvsInFile() {
        return this.GnsList_;
    }

    public String getSvsInFile(int index) {
        return (String)this.GnsList_.toArray()[index];
    }

    public Iterator<String> getSvsInFileIterator() {
        return this.GnsList_.iterator();
    }

    public ArrayList<String> getTitle() {
        return this.Title_;
    }

    public String getTitle(int i) {
        return this.Title_.get(i);
    }

    public String getXAxisLabel() {
        return this.XAxisLabel_;
    }

    public String getYAxisLabel() {
        return this.YAxisLabel_;
    }

    public String getPlotType() {
        return this.FileFormat_;
    }

    public String getStatus() {
        return this.Status_;
    }

    public String getXType() {
        return this.Types_.get(0);
    }

    public String getYType() {
        return this.Types_.get(this.Types_.size() - 1);
    }

    public int readDataPoint(List<Object> x_sto, List<HashMap<String, Vector<Object>>> y_sto) {
        if (this.FileFormat_.equalsIgnoreCase("OMNI")) {
            return this.readOmniPlotData(x_sto, y_sto);
        }
        if (this.FileFormat_.equalsIgnoreCase("XY")) {
            return this.readXY(x_sto, y_sto);
        }
        return 9999;
    }

    public int readOmniPlotHeader() {
        if (this.Ios_ == 0) {
            try {
                String text = this.FileStream_.readLine();
                this.CharRead_ += (long)text.length();
                this.YAxisLabel_ = text.trim();
                this.XAxisLabel_ = "";
                text = this.FileStream_.readLine();
                this.CharRead_ += (long)text.length();
                String[] tokens = text.trim().split("[\\s,;]+");
                this.nStations_ = Integer.parseInt(tokens[0]);
                this.nFrequencies_ = Integer.parseInt(tokens[1]);
                this.nPlots_ = this.nStations_ * this.nFrequencies_;
                this.Title_.clear();
                for (int i = 0; i < this.nPlots_; ++i) {
                    text = this.FileStream_.readLine();
                    this.CharRead_ += (long)text.length();
                    this.Title_.add(text.trim());
                }
                this.XMax_ = null;
                this.XMin_ = null;
                this.YMax_.clear();
                this.YMin_.clear();
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe IN HEADER = " + nfe.getMessage();
                this.Ios_ = 1001;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe IN HEADER = " + sioobe.getMessage();
                this.Ios_ = 1002;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                this.Ios_ = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re IN HEADER = " + re.getMessage();
                this.Ios_ = 1003;
            }
            catch (IOException e) {
                this.Status_ = "e IN HEADER = " + e.getMessage();
                this.Ios_ = 1004;
            }
        }
        return this.Ios_;
    }

    public int readOmniPlotData(List<Object> x_sto, List<HashMap<String, Vector<Object>>> y_sto) {
        if (this.Ios_ == 0) {
            try {
                String text = this.FileStream_.readLine();
                if (text != null) {
                    this.Matcher_ = this.OmniEpochFormat_.matcher(text);
                    if (this.Matcher_.find(0)) {
                        this.CharRead_ += (long)text.length();
                        int year = Integer.parseInt(this.Matcher_.group(1));
                        int month = Integer.parseInt(this.Matcher_.group(2));
                        int day = Integer.parseInt(this.Matcher_.group(3));
                        int hour = Integer.parseInt(this.Matcher_.group(4));
                        int minute = Integer.parseInt(this.Matcher_.group(5));
                        int second = 0;
                        if (this.Matcher_.group(6) != null) {
                            second = Integer.parseInt(this.Matcher_.group(6));
                        }
                        int milli = 0;
                        if (this.Matcher_.group(7) != null) {
                            if (this.Matcher_.group(7).length() == 2) {
                                milli = 100 * Integer.parseInt(this.Matcher_.group(7).substring(1));
                            } else if (this.Matcher_.group(7).length() == 3) {
                                milli = 10 * Integer.parseInt(this.Matcher_.group(7).substring(1));
                            } else if (this.Matcher_.group(7).length() >= 4) {
                                milli = Integer.parseInt(this.Matcher_.group(7).substring(1, 4));
                            }
                        }
                        if (year < 80) {
                            year += 2000;
                        } else if (year < 100) {
                            year += 1900;
                        }
                        this.Epoch_.set(year, month - 1, day, hour, minute, second);
                        this.Epoch_.set(14, milli);
                        if (this.EpochsRead_ == 0) {
                            this.XMax_ = this.Epoch_.getTime();
                            this.XMin_ = this.Epoch_.getTime();
                        } else if (this.Epoch_.getTimeInMillis() > ((Date)this.XMax_).getTime()) {
                            this.XMax_ = this.Epoch_.getTime();
                        } else if (this.Epoch_.getTimeInMillis() < ((Date)this.XMin_).getTime()) {
                            this.XMin_ = this.Epoch_.getTime();
                        }
                        text = this.Matcher_.group(8);
                        int index = 0;
                        int number_of_gns = Integer.parseInt(text.substring(index, index + 2).trim());
                        index += 2;
                        Vector<String> gns_list = new Vector<String>(number_of_gns);
                        for (int i = 0; i < number_of_gns; ++i) {
                            String gns = RinexGnsId.getId((String)text.substring(index, index + 3));
                            gns_list.add(gns);
                            index += 3;
                            if (this.GnsList_.contains(gns)) continue;
                            this.GnsList_.add(gns);
                        }
                        text = number_of_gns > 0 ? this.FileStream_.readLine() : "";
                        this.CharRead_ += (long)text.length();
                        HashMap all_sets = new HashMap();
                        index = 0;
                        for (int i = 0; i < number_of_gns; ++i) {
                            Vector<Double> one_set = new Vector<Double>(this.nPlots_);
                            int count = 0;
                            for (int j = 0; j < this.nFrequencies_; ++j) {
                                for (int k = 0; k < this.nStations_; ++k) {
                                    double value = Double.parseDouble(text.substring(index, index + 13));
                                    one_set.add(value);
                                    index += 13;
                                    if (!(StrictMath.abs(value - -9999.0) < 0.001)) {
                                        if (this.YMax_.size() <= count) {
                                            this.YMax_.add(value);
                                            this.YMin_.add(value);
                                        } else if ((Double)this.YMax_.get(count) < value) {
                                            this.YMax_.set(count, value);
                                        } else if ((Double)this.YMin_.get(count) > value) {
                                            this.YMin_.set(count, value);
                                        }
                                    }
                                    ++count;
                                }
                            }
                            all_sets.put(gns_list.get(i), one_set);
                        }
                        x_sto.add(this.Epoch_.getTime());
                        y_sto.add(all_sets);
                        ++this.EpochsRead_;
                    } else {
                        this.Status_ = "bad OMNI epoch line at epoch " + this.EpochsRead_;
                        this.Ios_ = 1101;
                    }
                } else {
                    this.Status_ = "eof reached";
                    this.Ios_ = -1;
                }
            }
            catch (NumberFormatException nfe) {
                this.Status_ = "nfe IN DATA = " + nfe.getMessage() + " at epoch " + this.EpochsRead_;
                this.Ios_ = 1102;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                this.Status_ = "sioobe IN DATA = " + sioobe.getMessage() + " at epoch " + this.EpochsRead_;
                this.Ios_ = 1103;
            }
            catch (EOFException eof) {
                this.Status_ = "eof reached";
                this.Ios_ = -1;
            }
            catch (RuntimeException re) {
                this.Status_ = "re IN DATA = " + re.getMessage() + " at epoch " + this.EpochsRead_;
                this.Ios_ = 1104;
            }
            catch (IOException e) {
                this.Status_ = "e IN DATA = " + e.getMessage() + " at epoch " + this.EpochsRead_;
                this.Ios_ = 1105;
            }
        }
        return this.Ios_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readXY(List<Object> x_sto, List<HashMap<String, Vector<Object>>> y_sto) {
        if (this.Ios_ != 0) return this.Ios_;
        try {
            Comparable<Date> value;
            String tmp;
            int i;
            int itokens;
            String[] tokens;
            block35: {
                block36: {
                    block34: {
                        String mod_tmp;
                        String text = this.FileStream_.readLine();
                        if (text == null) {
                            this.Ios_ = -1;
                            return this.Ios_;
                        }
                        this.CharRead_ += (long)text.length();
                        tokens = text.trim().split("[\\s,;]+");
                        itokens = 0;
                        if (tokens.length == 0) {
                            return this.Ios_;
                        }
                        if (tokens.length != this.Types_.size()) {
                            this.Status_ = "bad XY data line " + this.EpochsRead_;
                            this.Ios_ = 2102;
                            return this.Ios_;
                        }
                        i = 0;
                        tmp = tokens[itokens];
                        if (this.Types_.get(i).equalsIgnoreCase("full")) {
                            this.Matcher_ = this.Separators_.matcher(tmp);
                            mod_tmp = this.Matcher_.replaceAll(" ");
                            value = this.FullFormat_.parse(mod_tmp);
                            ++i;
                        } else if (this.Types_.get(i).equalsIgnoreCase("date") && this.Types_.get(i).equalsIgnoreCase("time")) {
                            this.Matcher_ = this.Separators_.matcher(tmp);
                            String mod_1 = this.Matcher_.replaceAll(" ");
                            this.Matcher_ = this.Separators_.matcher(tokens[++itokens]);
                            String mod_2 = this.Matcher_.replaceAll(" ");
                            value = new Date(this.DateFormat_.parse(mod_1).getTime() + this.TimeFormat_.parse(mod_2).getTime());
                            i += 2;
                        } else if (this.Types_.get(i).equalsIgnoreCase("date")) {
                            this.Matcher_ = this.Separators_.matcher(tmp);
                            mod_tmp = this.Matcher_.replaceAll(" ");
                            value = this.DateFormat_.parse(mod_tmp);
                            x_sto.add(value);
                            ++i;
                        } else if (this.Types_.get(i).equalsIgnoreCase("time")) {
                            this.Matcher_ = this.Separators_.matcher(tmp);
                            mod_tmp = this.Matcher_.replaceAll(" ");
                            value = this.TimeFormat_.parse(mod_tmp);
                            ++i;
                        } else {
                            value = Double.valueOf(tmp);
                            ++i;
                        }
                        x_sto.add(value);
                        if (this.EpochsRead_ != 0) break block34;
                        this.XMax_ = value;
                        this.XMin_ = value;
                        break block35;
                    }
                    if (!(value instanceof Date)) break block36;
                    if (((Date)value).getTime() > ((Date)this.XMax_).getTime()) {
                        this.XMax_ = value;
                        break block35;
                    } else if (((Date)value).getTime() < ((Date)this.XMin_).getTime()) {
                        this.XMin_ = value;
                    }
                    break block35;
                }
                if (((Double)value).compareTo((Double)this.XMax_) > 0) {
                    this.XMax_ = value;
                } else if (((Double)value).compareTo((Double)this.XMin_) < 0) {
                    this.XMin_ = value;
                }
            }
            for (int j = i; j < this.Types_.size(); ++j) {
                if (!this.Types_.get(i).equalsIgnoreCase("decimal")) continue;
                this.GnsList_.add(this.YName_.format(j - i + 1));
            }
            HashMap all_sets = new HashMap();
            Iterator itr = this.GnsList_.iterator();
            int j = i;
            while (true) {
                if (j >= this.Types_.size()) {
                    ++this.EpochsRead_;
                    y_sto.add(all_sets);
                    return this.Ios_;
                }
                tmp = tokens[++itokens];
                Vector<Comparable<Date>> one_set = new Vector<Comparable<Date>>(1);
                if (!this.Types_.get(i).equalsIgnoreCase("decimal")) {
                    this.Ios_ = 2201;
                    return this.Ios_;
                }
                String gns = (String)itr.next();
                value = Double.valueOf(tmp);
                one_set.add(value);
                if (!(StrictMath.abs((Double)value - -9999.0) < 0.001)) {
                    if (this.YMax_.size() == 0) {
                        this.YMax_.add(value);
                        this.YMin_.add(value);
                    } else if (((Double)this.YMax_.get(0)).compareTo((Double)value) < 0) {
                        this.YMax_.set(0, value);
                    } else if (((Double)this.YMin_.get(0)).compareTo((Double)value) > 0) {
                        this.YMin_.set(0, value);
                    }
                }
                all_sets.put(gns, one_set);
                ++j;
            }
        }
        catch (NumberFormatException nfe) {
            this.Status_ = "nfe IN DATA = " + nfe.getMessage() + " at epoch " + this.EpochsRead_;
            this.Ios_ = 2103;
            return this.Ios_;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            this.Status_ = "sioobe IN DATA = " + sioobe.getMessage() + " at epoch " + this.EpochsRead_;
            this.Ios_ = 2104;
            return this.Ios_;
        }
        catch (EOFException eof) {
            this.Status_ = "eof reached";
            this.Ios_ = -1;
            return this.Ios_;
        }
        catch (RuntimeException re) {
            this.Status_ = "re IN DATA = " + re.getMessage();
            this.Ios_ = 2105;
            return this.Ios_;
        }
        catch (IOException e) {
            this.Status_ = "e IN DATA = " + e.getMessage();
            this.Ios_ = 2106;
            return this.Ios_;
        }
        catch (ParseException pe) {
            this.Status_ = "pe IN DATA = " + pe.getMessage();
            this.Ios_ = 2107;
        }
        return this.Ios_;
    }

    public int testXY() {
        this.Ios_ = 0;
        try {
            String text = this.FileStream_.readLine();
            if (text == null) {
                this.Ios_ = -1;
                System.err.println("READ error In testXY, Ios_ = " + this.Ios_);
                this.FileFormat_ = null;
                this.nPlots_ = 0;
                this.Types_.clear();
                return this.Ios_;
            }
            this.CharRead_ += (long)text.length();
            String[] tokens = text.trim().split("[\\s,;]+");
            int itokens = 0;
            if (tokens.length > 1) {
                String last = "";
                this.nPlots_ = 0;
                int count = 0;
                while (itokens < tokens.length) {
                    String tmp = tokens[itokens];
                    ++itokens;
                    this.Matcher_ = this.FullPattern_.matcher(tmp);
                    if (this.Matcher_.find(0)) {
                        this.Types_.add("full");
                        last = "full";
                        ++count;
                        continue;
                    }
                    this.Matcher_ = this.DatePattern_.matcher(tmp);
                    if (this.Matcher_.find(0)) {
                        this.Types_.add("date");
                        if (!last.equalsIgnoreCase("time")) {
                            ++count;
                        }
                        last = "date";
                        continue;
                    }
                    this.Matcher_ = this.TimePattern_.matcher(tmp);
                    if (this.Matcher_.find(0)) {
                        this.Types_.add("time");
                        if (!last.equalsIgnoreCase("date")) {
                            ++count;
                        }
                        last = "time";
                        continue;
                    }
                    this.Matcher_ = this.NumbPattern_.matcher(tmp);
                    if (this.Matcher_.find(0)) {
                        this.Types_.add("decimal");
                        ++count;
                        last = "decimal";
                        continue;
                    }
                    this.Ios_ = 2001;
                    System.err.println("READ error In testXY, Ios_ = " + this.Ios_);
                    this.FileFormat_ = null;
                    this.nPlots_ = 0;
                    this.Types_.clear();
                    return this.Ios_;
                }
                if (count > 1) {
                    this.nFrequencies_ = 1;
                    this.nStations_ = 1;
                    this.nPlots_ = this.nStations_ * this.nFrequencies_;
                    this.FileFormat_ = "XY";
                    this.Title_.clear();
                    this.Title_.add("XY Plot");
                    this.XAxisLabel_ = "X";
                    this.YAxisLabel_ = "Y";
                } else {
                    System.err.println("Wrong number of tokens error In testXY");
                    System.err.println("Read " + this.nPlots_ + " tokens");
                    System.err.println("input line was: " + text);
                    this.FileFormat_ = null;
                    this.nPlots_ = 0;
                    this.Types_.clear();
                }
            } else {
                System.err.println("Wrong number of tokens error In testXY");
                System.err.println("Read " + tokens.length + " tokens");
                System.err.println("input line was: " + text);
                this.FileFormat_ = null;
                this.nPlots_ = 0;
                this.Types_.clear();
            }
            this.XMax_ = null;
            this.XMin_ = null;
            this.YMax_.clear();
            this.YMin_.clear();
            this.FileStream_.close();
            this.FileStream_ = new BufferedReader(new FileReader(this.File_), 10240);
        }
        catch (NumberFormatException nfe) {
            this.Status_ = "nfe IN DATA = " + nfe.getMessage() + " at epoch " + this.EpochsRead_;
            this.Ios_ = 2002;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            this.Status_ = "sioobe IN DATA = " + sioobe.getMessage() + " at epoch " + this.EpochsRead_;
            this.Ios_ = 2003;
        }
        catch (EOFException eof) {
            this.Status_ = "eof reached";
            this.Ios_ = -1;
        }
        catch (RuntimeException re) {
            this.Status_ = "re IN DATA = " + re.getMessage();
            this.Ios_ = 2004;
        }
        catch (IOException e) {
            this.Status_ = "e IN DATA = " + e.getMessage();
            this.Ios_ = 2005;
        }
        return this.Ios_;
    }

    public long length() {
        return this.FileLength_;
    }

    public long tell() {
        return 100L;
    }

    public int tellPercentage() {
        return 100;
    }
}

