/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GPos.Vupos.PlotCanvas;
import GPos.Vupos.PlotDoubleSpinnerModel;
import GPos.Vupos.Vupos;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class PlotDoubleLimitsDialog
extends JDialog {
    private JPanel ButtonPanel_;
    private JButton CancelButton_;
    private JLabel IconLabel_;
    private JLabel MaxLabel_;
    private JSpinner MaxSpinner_;
    private JLabel MinLabel_;
    private JSpinner MinSpinner_;
    private JButton OkButton_;
    String Type_ = "";
    boolean OkToClose_;
    public static final int X = 0;
    public static final int Y = 1;

    public PlotDoubleLimitsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public PlotDoubleLimitsDialog(Vupos parent, String type, boolean modal) {
        super((Frame)parent, modal);
        this.getRootPane().setWindowDecorationStyle(7);
        this.initComponents();
        this.Type_ = type != null ? type.trim() : "";
        if (type != null && type.length() > 0) {
            this.setTitle(((Vupos)this.getParent()).i18nString("EditLimitsTitleA", "Edit Plot") + " " + this.Type_ + " " + ((Vupos)this.getParent()).i18nString("EditLimitsTitleB", "Limits."));
        } else {
            this.setTitle(((Vupos)this.getParent()).i18nString("EditLimitsTitle", "Edit Plot Limits."));
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                PlotDoubleLimitsDialog.this.OkToClose_ = false;
                PlotDoubleLimitsDialog.this.setVisible(false);
            }
        });
    }

    private void initComponents() {
        this.IconLabel_ = new JLabel();
        this.MinLabel_ = new JLabel();
        this.MaxLabel_ = new JLabel();
        this.MinSpinner_ = new JSpinner();
        this.MaxSpinner_ = new JSpinner();
        this.ButtonPanel_ = new JPanel();
        this.OkButton_ = new JButton();
        this.CancelButton_ = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.IconLabel_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/Help24.gif")));
        this.IconLabel_.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.IconLabel_, gridBagConstraints);
        this.MinLabel_.setText("Min:");
        this.MinLabel_.setToolTipText("Enter minimum limit.");
        this.MinLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.MinLabel_, gridBagConstraints);
        this.MaxLabel_.setText("Max:");
        this.MaxLabel_.setToolTipText("Enter maximum limit.");
        this.MaxLabel_.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.MaxLabel_, gridBagConstraints);
        this.MinSpinner_.setModel(new PlotDoubleSpinnerModel());
        this.MinSpinner_.setToolTipText("Enter minimum limit.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.MinSpinner_, gridBagConstraints);
        this.MaxSpinner_.setModel(new PlotDoubleSpinnerModel());
        this.MaxSpinner_.setToolTipText("Enter maximum limit.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.MaxSpinner_, gridBagConstraints);
        this.ButtonPanel_.setLayout(new GridBagLayout());
        this.OkButton_.setMnemonic(((Vupos)this.getParent()).i18nString("OkMnemonic", "O").charAt(0));
        this.OkButton_.setText(" " + ((Vupos)this.getParent()).i18nString("Ok", "OK") + " ");
        this.OkButton_.setToolTipText(((Vupos)this.getParent()).i18nString("OkToolTip", "Save the values and close window."));
        this.OkButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotDoubleLimitsDialog.this.OkButton_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.ButtonPanel_.add((Component)this.OkButton_, gridBagConstraints);
        this.CancelButton_.setMnemonic('c');
        this.CancelButton_.setText("Cancel");
        this.CancelButton_.setToolTipText("Leave without changing values.");
        this.CancelButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotDoubleLimitsDialog.this.CancelButton_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.ButtonPanel_.add((Component)this.CancelButton_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.ButtonPanel_, gridBagConstraints);
        this.pack();
    }

    private void CancelButton_ActionPerformed(ActionEvent evt) {
        this.OkToClose_ = false;
        this.setVisible(false);
    }

    private void OkButton_ActionPerformed(ActionEvent evt) {
        int m = ((Double)this.MaxSpinner_.getValue()).compareTo((Double)this.MinSpinner_.getValue());
        if (m < 0) {
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(this, "max < min\nSwap max and min values?", "max < min", 0, 0, null, options, options[0]);
            if (n == 0) {
                Double v1 = (Double)this.MaxSpinner_.getValue();
                Double v2 = (Double)this.MinSpinner_.getValue();
                this.MaxSpinner_.setValue(v2);
                this.MinSpinner_.setValue(v1);
                this.OkToClose_ = true;
                this.setVisible(false);
            }
        } else if (m == 0) {
            JOptionPane.showMessageDialog(this, "max = min.", "max = min", 0);
        } else {
            this.OkToClose_ = true;
            this.setVisible(false);
        }
    }

    public boolean isMaxOk() {
        return true;
    }

    public boolean isMinOk() {
        return true;
    }

    public boolean isOk() {
        return this.OkToClose_ && this.isMaxOk() && this.isMinOk();
    }

    public Object getMax() {
        return this.MaxSpinner_.getValue();
    }

    public Object getMin() {
        return this.MinSpinner_.getValue();
    }

    public void setCanvas(PlotCanvas canvas, int type) {
        if (type == 0) {
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).drawLimit(canvas, 1);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).drawLimit(canvas, 0);
        } else if (type == 1) {
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).drawLimit(canvas, 3);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).drawLimit(canvas, 2);
        }
    }

    public void setLimits(Comparable min_limit, Comparable max_limit) {
        if (((Double)min_limit).compareTo((Double)max_limit) < 0) {
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setMaximum(max_limit);
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setMinimum(min_limit);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setMaximum(max_limit);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setMinimum(min_limit);
        } else if (((Double)min_limit).compareTo((Double)max_limit) > 0) {
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setMaximum(max_limit);
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setMinimum(min_limit);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setMaximum(max_limit);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setMinimum(min_limit);
        } else {
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setMaximum(max_limit);
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setMinimum(min_limit);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setMaximum(max_limit);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setMinimum(min_limit);
        }
    }

    private void setMax(Object input) {
        this.MaxSpinner_.setValue(input);
    }

    private void setMin(Object input) {
        this.MinSpinner_.setValue(input);
    }

    public void setValues(Object min_value, Object max_value) {
        if (((Double)min_value).compareTo((Double)max_value) < 0) {
            this.MaxSpinner_.setValue(max_value);
            this.MinSpinner_.setValue(min_value);
            double diff = StrictMath.abs((Double)max_value - (Double)min_value);
            double step = StrictMath.pow(10.0, StrictMath.floor(StrictMath.log10(diff)) - 1.0);
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setStepSize(step);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setStepSize(step);
        } else if (((Double)min_value).compareTo((Double)max_value) > 0) {
            this.MaxSpinner_.setValue(min_value);
            this.MinSpinner_.setValue(max_value);
            double diff = StrictMath.abs((Double)max_value - (Double)min_value);
            double step = StrictMath.pow(10.0, StrictMath.floor(StrictMath.log10(diff)) - 1.0);
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setStepSize(step);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setStepSize(step);
        } else {
            this.MaxSpinner_.setValue(max_value);
            this.MinSpinner_.setValue(min_value);
            ((PlotDoubleSpinnerModel)this.MaxSpinner_.getModel()).setStepSize(1.0);
            ((PlotDoubleSpinnerModel)this.MinSpinner_.getModel()).setStepSize(1.0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PlotDoubleLimitsDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

