/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GPos.Vupos.BreakInstruction;
import GPos.Vupos.KillInstruction;
import GPos.Vupos.PlotCanvas;
import GPos.Vupos.PlotDateLimitsDialog;
import GPos.Vupos.PlotDoubleLimitsDialog;
import GPos.Vupos.PlotFile;
import GPos.Vupos.PlotLimitsStack;
import GPos.Vupos.PlotList;
import GPos.Vupos.PlotTableModel;
import GPos.Vupos.ScnFile;
import GPos.Vupos.SwingWorker;
import GPos.Vupos.Vupos;
import GPosGui.GpsDateSpinnerEditor;
import GPosGui.KPosFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotControls
extends JPanel
implements ItemListener {
    private JButton AutoScaleButton_;
    private JPanel CanvasHolder_;
    private JButton DeselectButton_;
    private JPanel GnssSelectionPanel_;
    private JScrollPane GnssSelectionScrollPane_;
    private JButton ListButton_;
    private JPanel ListControlPanel_;
    private JToolBar PlotControlToolBar_;
    private JComboBox PlotSelection_;
    private JProgressBar Progress_;
    private JButton SelectButton_;
    private JPanel StatusProgressHolder_;
    private JLabel Status_;
    private JButton ZoomOutButton_;
    private final String DefaultDateFormat_ = "YYYY-DDD";
    private final String HelpSetName_ = "KgpsPlotHelp.hs";
    private final int TENTH_SECOND = 100;
    private final int ONE_SECOND = 1000;
    private boolean ScenariosOn_ = true;
    private int LastIOS_ = 0;
    private int LastPlotSelection_ = -1;
    private int NumberOfDataPoints_ = 0;
    private int ReadingFile_ = 0;
    private ArrayList<Short> PlotStackTop_ = new ArrayList();
    private PlotLimitsStack PlotStack_ = new PlotLimitsStack();
    private Object PlotXMax_;
    private Object PlotXMin_;
    private Object PlotYMax_;
    private Object PlotYMin_;
    private SortedSet<Date> Scenarios_ = new TreeSet<Date>();
    private Font GnsButtonFont_;
    private Vupos Parent_;
    private PlotFile PlotFile_;
    private String BrkName_ = null;
    private String EdtName_ = null;
    private String FileName_ = null;
    private String FullName_ = null;
    private String CurrentPath_ = ".";
    private String[] GnsButtonLabel_;
    private String PlotTitle_;
    private String PlotXAxisLabel_;
    private String PlotYAxisLabel_;
    private File BrkFile_ = null;
    private File EdtFile_ = null;
    private Timer Timer_;
    private JCheckBox[] GnsButton_;
    private PlotCanvas PlotCanvas_;
    private PlotDateLimitsDialog XDateLimits_;
    private PlotDateLimitsDialog YDateLimits_;
    private PlotDoubleLimitsDialog XDoubleLimits_;
    private PlotDoubleLimitsDialog YDoubleLimits_;
    private PlotList PlotList_;
    private PlotTableModel TableModel_ = new PlotTableModel();
    private static final Pattern GnsSelectPattern_ = Pattern.compile("text=([A-Za-z0-9 ()]*)");

    public PlotControls(Vupos parent) {
        this.Parent_ = parent;
        this.PlotCanvas_ = new PlotCanvas(this, "YYYY-DDD");
        this.PlotList_ = new PlotList(this.Parent_, this, "YYYY-DDD", false);
        this.XDateLimits_ = new PlotDateLimitsDialog(this.Parent_, "X", true);
        this.XDateLimits_.setCanvas(this.PlotCanvas_, 0);
        this.XDoubleLimits_ = new PlotDoubleLimitsDialog(this.Parent_, "X", true);
        this.XDoubleLimits_.setCanvas(this.PlotCanvas_, 0);
        this.YDateLimits_ = new PlotDateLimitsDialog(this.Parent_, "Y", true);
        this.YDateLimits_.setCanvas(this.PlotCanvas_, 1);
        this.YDoubleLimits_ = new PlotDoubleLimitsDialog(this.Parent_, "Y", true);
        this.YDoubleLimits_.setCanvas(this.PlotCanvas_, 1);
        this.XDateLimits_.setFormat("YYYY-DDD");
        this.YDateLimits_.setFormat("YYYY-DDD");
        this.initComponents();
        this.GnsButtonFont_ = new Font("MonoSpaced", 1, 12);
    }

    public PlotControls(Vupos parent, String file_name, boolean help_flag, String date_format) {
        this(parent);
        this.setDateFormat(date_format);
        if (file_name.length() > 0) {
            this.OpenItemHandler(file_name);
        }
    }

    private void initComponents() {
        this.CanvasHolder_ = new JPanel();
        this.PlotControlToolBar_ = new JToolBar();
        this.PlotSelection_ = new JComboBox();
        this.AutoScaleButton_ = new JButton();
        this.ZoomOutButton_ = new JButton();
        this.ListControlPanel_ = new JPanel();
        this.DeselectButton_ = new JButton();
        this.SelectButton_ = new JButton();
        this.ListButton_ = new JButton();
        this.GnssSelectionScrollPane_ = new JScrollPane();
        this.GnssSelectionPanel_ = new JPanel();
        this.StatusProgressHolder_ = new JPanel();
        this.Status_ = new JLabel();
        this.Progress_ = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.CanvasHolder_.setLayout(new BorderLayout());
        this.CanvasHolder_.add((Component)this.PlotCanvas_, "Center");
        this.PlotCanvas_.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                PlotControls.this.PlotCanvas_ComponentResized(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.CanvasHolder_, gridBagConstraints);
        this.PlotControlToolBar_.setFloatable(false);
        this.PlotSelection_.setModel(new DefaultComboBoxModel<String>(new String[]{this.Parent_.i18nString("NoPlot", "No plot")}));
        this.PlotSelection_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotControls.this.PlotSelection_ActionPerformed(evt);
            }
        });
        this.PlotControlToolBar_.add(this.PlotSelection_);
        this.AutoScaleButton_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/Auto16.gif")));
        this.AutoScaleButton_.setToolTipText(this.Parent_.i18nString("AutoscaleButtonToolTip", "Autoscale the plot."));
        this.AutoScaleButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotControls.this.AutoScaleButton_ActionPerformed(evt);
            }
        });
        this.PlotControlToolBar_.add(this.AutoScaleButton_);
        this.ZoomOutButton_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/ZoomOut16.gif")));
        this.ZoomOutButton_.setToolTipText(this.Parent_.i18nString("ZoomOutButtonToolTip", "Zoom out."));
        this.ZoomOutButton_.setEnabled(false);
        this.ZoomOutButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotControls.this.ZoomOutButton_ActionPerformed(evt);
            }
        });
        this.PlotControlToolBar_.add(this.ZoomOutButton_);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.PlotControlToolBar_, gridBagConstraints);
        this.DeselectButton_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/Up16.gif")));
        this.DeselectButton_.setMnemonic('d');
        this.DeselectButton_.setToolTipText(this.Parent_.i18nString("DeselectButtonToolTip", "Deselect all."));
        this.DeselectButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotControls.this.DeselectButton_ActionPerformed(evt);
            }
        });
        this.SelectButton_.setIcon(new ImageIcon(this.getClass().getResource("/GPosGui/images/Down16.gif")));
        this.SelectButton_.setMnemonic('s');
        this.SelectButton_.setToolTipText(this.Parent_.i18nString("SelectButtonToolTip", "Select all."));
        this.SelectButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotControls.this.SelectButton_ActionPerformed(evt);
            }
        });
        this.ListButton_.setMnemonic(this.Parent_.i18nString("ListButtonLabelMnemonic", "L").charAt(0));
        this.ListButton_.setText(this.Parent_.i18nString("ListButtonLabel", "List"));
        this.ListButton_.setToolTipText(this.Parent_.i18nString("ListButtonLabelToolTip", "Display a list of the data points."));
        this.ListButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotControls.this.ListButton_ActionPerformed(evt);
            }
        });
        GroupLayout GnssSelectionPanel_Layout = new GroupLayout(this.GnssSelectionPanel_);
        this.GnssSelectionPanel_.setLayout(GnssSelectionPanel_Layout);
        GnssSelectionPanel_Layout.setHorizontalGroup(GnssSelectionPanel_Layout.createParallelGroup(1).add(0, 141, Short.MAX_VALUE));
        GnssSelectionPanel_Layout.setVerticalGroup(GnssSelectionPanel_Layout.createParallelGroup(1).add(0, 346, Short.MAX_VALUE));
        this.GnssSelectionScrollPane_.setViewportView(this.GnssSelectionPanel_);
        GroupLayout ListControlPanel_Layout = new GroupLayout(this.ListControlPanel_);
        this.ListControlPanel_.setLayout(ListControlPanel_Layout);
        ListControlPanel_Layout.setHorizontalGroup(ListControlPanel_Layout.createParallelGroup(1).add(ListControlPanel_Layout.createSequentialGroup().add(this.DeselectButton_).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.SelectButton_)).add(this.GnssSelectionScrollPane_, -1, 106, Short.MAX_VALUE).add(this.ListButton_, -2, 106, Short.MAX_VALUE));
        ListControlPanel_Layout.setVerticalGroup(ListControlPanel_Layout.createParallelGroup(1).add(ListControlPanel_Layout.createSequentialGroup().add(ListControlPanel_Layout.createParallelGroup(3).add(this.DeselectButton_).add(this.SelectButton_)).addPreferredGap(0).add(this.GnssSelectionScrollPane_, -1, 364, Short.MAX_VALUE).addPreferredGap(0).add(this.ListButton_, -2, 33, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.ListControlPanel_, gridBagConstraints);
        this.StatusProgressHolder_.setBorder(new SoftBevelBorder(0));
        this.Status_.setText(this.Parent_.i18nString("StatusInitString", "Open a plot file or launch the help tool."));
        this.Status_.setToolTipText(this.Parent_.i18nString("SelectButtonToolTip", "Program status."));
        GroupLayout StatusProgressHolder_Layout = new GroupLayout(this.StatusProgressHolder_);
        this.StatusProgressHolder_.setLayout(StatusProgressHolder_Layout);
        StatusProgressHolder_Layout.setHorizontalGroup(StatusProgressHolder_Layout.createParallelGroup(1).add(2, StatusProgressHolder_Layout.createSequentialGroup().add(this.Status_, -1, 546, Short.MAX_VALUE).addPreferredGap(0).add(this.Progress_, -2, 103, -2)));
        StatusProgressHolder_Layout.setVerticalGroup(StatusProgressHolder_Layout.createParallelGroup(1).add(2, this.Progress_, -1, 27, Short.MAX_VALUE).add(2, this.Status_, -1, 27, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.StatusProgressHolder_, gridBagConstraints);
    }

    private void PlotSelection_ActionPerformed(ActionEvent evt) {
        this.setPlotSelection(this.PlotSelection_.getSelectedIndex());
    }

    private void SelectButton_ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.GnsButton_.length; ++i) {
            if (this.GnsButton_[i] == null) continue;
            this.GnsButton_[i].setSelected(true);
        }
        this.SelectButton_.setEnabled(false);
        this.DeselectButton_.setEnabled(true);
        this.PlotCanvas_.draw();
    }

    private void DeselectButton_ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.GnsButton_.length; ++i) {
            if (this.GnsButton_[i] == null) continue;
            this.GnsButton_[i].setSelected(false);
        }
        this.DeselectButton_.setEnabled(false);
        this.SelectButton_.setEnabled(true);
        this.PlotCanvas_.draw();
    }

    private void AutoScaleButton_ActionPerformed(ActionEvent evt) {
        this.autoscale();
    }

    private void ZoomOutButton_ActionPerformed(ActionEvent evt) {
        this.zoomOut();
    }

    private void ListButton_ActionPerformed(ActionEvent evt) {
        if (this.FileName_ == null) {
            this.Status_.setText(this.Parent_.i18nString("ListNoPlot", "Open a plot file first."));
        } else {
            this.openListFrame(this.FileName_);
        }
    }

    private void PlotCanvas_ComponentResized(ComponentEvent evt) {
        this.PlotCanvas_.draw();
    }

    public void print() throws PrinterException {
        this.PlotCanvas_.PrintCanvas();
    }

    public void setDateTimeFormat(String input) {
        if (input != null) {
            for (String format : GpsDateSpinnerEditor.getValidDateFormats()) {
                if (!input.equalsIgnoreCase(format)) continue;
                this.PlotCanvas_.setDateFormat(input);
                this.PlotList_.setDateFormat(input);
                break;
            }
        }
    }

    public void OpenItemHandler(String file_name) {
        if (file_name != null && file_name.trim().length() > 0) {
            this.PlotFile_ = new PlotFile(file_name);
            if (this.PlotFile_.getIos() != 0) {
                this.PlotSelection_.setEnabled(false);
                this.Status_.setText("Open file error.");
                JOptionPane.showMessageDialog(this.Parent_, file_name + "\n" + this.Parent_.i18nString("ErrorFileOpen", "File Open Error") + ": " + this.PlotFile_.getIos(), this.Parent_.i18nString("ErrorFileOpen", "File Open Error"), 0);
                return;
            }
            if (this.PlotFile_.getFileFormat() != 0) {
                this.PlotSelection_.setEnabled(false);
                this.Status_.setText("File format error.");
                JOptionPane.showMessageDialog(this.Parent_, file_name + "\n" + this.Parent_.i18nString("ErrorFileFormat", "File Format Error") + ": " + this.Parent_.i18nString("ErrorFileFormatDescription", "not a standard format or X-Y table."), this.Parent_.i18nString("ErrorFileFormat", "File Format Error"), 0);
                return;
            }
            ++this.ReadingFile_;
            this.PlotSelection_.setEnabled(true);
            this.clearPlotData();
            final ReadPlotFileTask task = new ReadPlotFileTask();
            this.Timer_ = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (task.isDone()) {
                        PlotControls.this.Timer_.stop();
                        PlotControls.this.Progress_.setValue(0);
                        PlotControls.this.Status_.setText(task.getMessage());
                        --PlotControls.this.ReadingFile_;
                        PlotControls.this.PlotCanvas_.draw();
                        PlotControls.this.setCursor(null);
                        Toolkit.getDefaultToolkit().beep();
                        if (PlotControls.this.LastIOS_ > 0) {
                            JOptionPane.showMessageDialog(PlotControls.this.Parent_, PlotControls.this.PlotFile_.getName() + "\n" + PlotControls.this.Parent_.i18nString("ErrorFileRead", "File Read Error") + ": " + PlotControls.this.LastIOS_ + "\n" + PlotControls.this.PlotFile_.getStatus(), PlotControls.this.Parent_.i18nString("ErrorFileRead", "File Read Error"), 2);
                        } else if (PlotControls.this.NumberOfDataPoints_ == 0) {
                            JOptionPane.showMessageDialog(PlotControls.this.Parent_, PlotControls.this.PlotFile_.getName() + "\n" + PlotControls.this.Parent_.i18nString("ErrorFileEmptyDescription", "this file appears to contain no data points."), PlotControls.this.Parent_.i18nString("ErrorFileEmpty", "Empty File"), 2);
                        }
                    } else {
                        PlotControls.this.Progress_.setValue(task.getCurrent());
                        PlotControls.this.Status_.setText(task.getMessage());
                    }
                }
            });
            task.go();
            this.Timer_.start();
            this.FullName_ = this.PlotFile_.getAbsolutePath();
            this.FileName_ = this.PlotFile_.getName();
            this.CurrentPath_ = this.FullName_.substring(0, this.FullName_.length() - this.FileName_.length() - 1);
            this.readScenarioFile();
        } else {
            this.FileName_ = null;
            this.FullName_ = null;
        }
    }

    public void showXAxisDialog() {
        this.PlotCanvas_.xLimitsOn(this.PlotXMin_, this.PlotXMax_);
        if (this.PlotXMax_ instanceof Double) {
            this.XDoubleLimits_.setValues(this.PlotXMin_, this.PlotXMax_);
            this.XDoubleLimits_.setVisible(true);
            if (this.XDoubleLimits_.isOk()) {
                this.resize(this.XDoubleLimits_.getMin(), this.XDoubleLimits_.getMax(), this.PlotYMin_, this.PlotYMax_);
            }
        } else {
            this.XDateLimits_.setValues(this.PlotXMin_, this.PlotXMax_);
            this.XDateLimits_.setVisible(true);
            if (this.XDateLimits_.isOk()) {
                this.resize(this.XDateLimits_.getMin(), this.XDateLimits_.getMax(), this.PlotYMin_, this.PlotYMax_);
            }
        }
        this.PlotCanvas_.xLimitsOff();
    }

    public void showYAxisDialog() {
        this.PlotCanvas_.yLimitsOn(this.PlotYMin_, this.PlotYMax_);
        if (this.PlotYMax_ instanceof Double) {
            this.YDoubleLimits_.setValues(this.PlotYMin_, this.PlotYMax_);
            this.YDoubleLimits_.setVisible(true);
            if (this.YDoubleLimits_.isOk()) {
                this.resize(this.PlotXMin_, this.PlotXMax_, this.YDoubleLimits_.getMin(), this.YDoubleLimits_.getMax());
            }
        } else {
            this.YDateLimits_.setValues(this.PlotYMin_, this.PlotYMax_);
            this.YDateLimits_.setVisible(true);
            if (this.YDateLimits_.isOk()) {
                this.resize(this.PlotXMin_, this.PlotXMax_, this.YDateLimits_.getMin(), this.YDateLimits_.getMax());
            }
        }
        this.PlotCanvas_.yLimitsOff();
    }

    public void setTitle(String input) {
        if (input != null) {
            this.PlotTitle_ = input;
            this.PlotCanvas_.draw();
        }
    }

    public void setXAxisLabel(String input) {
        if (input != null) {
            this.PlotXAxisLabel_ = input;
            this.PlotCanvas_.draw();
        }
    }

    public void setYAxisLabel(String input) {
        if (input != null) {
            this.PlotYAxisLabel_ = input;
            this.PlotCanvas_.draw();
        }
    }

    public void setPlotSelection(int index) {
        if (index > -1 && index != this.LastPlotSelection_) {
            this.TableModel_.useDataSet(index);
            this.PlotList_.setTitle(this.Parent_.getProgramName() + ": " + this.PlotFile_.getTitle(index));
            this.PlotList_.setModel(index);
            this.PlotTitle_ = this.PlotFile_.getTitle(index);
            if (this.PlotStackTop_.get(index) == 0) {
                this.ZoomOutButton_.setEnabled(false);
            } else {
                this.ZoomOutButton_.setEnabled(true);
            }
            this.PlotXMin_ = this.PlotStack_.getXMin(index);
            this.PlotXMax_ = this.PlotStack_.getXMax(index);
            this.PlotYMin_ = this.PlotStack_.getYMin(index);
            this.PlotYMax_ = this.PlotStack_.getYMax(index);
            if (this.PlotXMax_.getClass().isInstance(this.XDoubleLimits_.getMax())) {
                this.XDoubleLimits_.setLimits((Double)this.PlotXMin_, (Double)this.PlotXMax_);
            } else {
                this.XDateLimits_.setLimits((Date)this.PlotXMin_, (Date)this.PlotXMax_);
            }
            if (this.PlotYMax_.getClass().isInstance(this.YDoubleLimits_.getMax())) {
                this.YDoubleLimits_.setLimits((Double)this.PlotYMin_, (Double)this.PlotYMax_);
            } else {
                this.YDateLimits_.setLimits((Date)this.PlotYMin_, (Date)this.PlotYMax_);
            }
            this.PlotCanvas_.draw(this.PlotXMin_, this.PlotXMax_, this.PlotYMin_, this.PlotYMax_);
            this.LastPlotSelection_ = index;
        }
    }

    public void setScenariosOn() {
        this.ScenariosOn_ = !this.ScenariosOn_;
        this.PlotCanvas_.draw();
    }

    public void setScenariosOn(boolean input) {
        if (input != this.ScenariosOn_) {
            this.ScenariosOn_ = input;
            this.PlotCanvas_.draw();
        }
    }

    public void addPlotSelection(String input) {
        this.PlotSelection_.addItem(input);
    }

    public void autoscale() {
        this.PlotCanvas_.autoscale(this.PlotStack_.getXMin(this.LastPlotSelection_, 0), this.PlotStack_.getXMax(this.LastPlotSelection_, 0), this.PlotStack_.getYMin(this.LastPlotSelection_, 0), this.PlotStack_.getYMax(this.LastPlotSelection_, 0));
    }

    private void clearPlotData() {
        this.TableModel_.clear();
        this.NumberOfDataPoints_ = 0;
        this.Progress_.setValue(0);
        this.Status_.setText("");
        this.setCursor(null);
    }

    public void clearStatusBar() {
        this.Status_.setText("");
    }

    public void createSVButtonPanel() {
        this.GnssSelectionPanel_.removeAll();
        this.GnssSelectionPanel_.setLayout(new BoxLayout(this.GnssSelectionPanel_, 1));
        this.GnsButton_ = new JCheckBox[this.PlotFile_.getNumberOfSatellites()];
        this.GnsButtonLabel_ = new String[this.PlotFile_.getNumberOfSatellites()];
        SVItemListener itemListener = new SVItemListener();
        Iterator<String> itr = this.PlotFile_.getSvsInFileIterator();
        int i = 0;
        while (itr.hasNext()) {
            String gns = itr.next();
            this.GnsButtonLabel_[i] = gns + "- " + this.PlotCanvas_.getSymbol(gns);
            this.GnsButton_[i] = new JCheckBox(this.GnsButtonLabel_[i], true);
            this.GnsButton_[i].addItemListener(itemListener);
            this.GnsButton_[i].setFont(this.GnsButtonFont_);
            this.GnssSelectionPanel_.add(this.GnsButton_[i]);
            ++i;
        }
        this.GnssSelectionPanel_.revalidate();
        this.GnssSelectionPanel_.repaint();
        this.PlotCanvas_.createGnsList();
    }

    public void deleteBrkFile() {
        int n;
        if (this.BrkFile_ != null && this.BrkFile_.exists() && (n = JOptionPane.showConfirmDialog(this.Parent_, this.Parent_.i18nString("DeleteBreakFileDescription", "Delete break file") + "\n" + this.BrkName_ + "?", this.Parent_.i18nString("DeleteFile", "Delete File"), 0)) == 0) {
            this.BrkFile_.delete();
        }
    }

    public void deleteEdtFile() {
        int n;
        if (this.EdtFile_ != null && this.EdtFile_.exists() && (n = JOptionPane.showConfirmDialog(this.Parent_, this.Parent_.i18nString("DeleteEditFileDescription", "Delete edit file") + "\n" + this.EdtName_ + "?", this.Parent_.i18nString("DeleteFile", "Delete File"), 0)) == 0) {
            this.EdtFile_.delete();
        }
    }

    public void enablePlotSelection(boolean input) {
        this.PlotSelection_.setEnabled(input);
    }

    public void enableZoomOutButton(boolean input) {
        this.ZoomOutButton_.setEnabled(input);
    }

    public Iterator<BreakInstruction> getBreakInstructionIterator() {
        return this.PlotList_.getBreakIterator();
    }

    public PlotCanvas getCanvas() {
        return this.PlotCanvas_;
    }

    public Iterator<String> getGnsListIterator() {
        return this.PlotFile_.getSvsInFileIterator();
    }

    public PlotList getList() {
        return this.PlotList_;
    }

    public String getListSelection() {
        return this.PlotList_.getCurrentSelection();
    }

    public int getNumberOfEpochs() {
        return this.PlotFile_.getNumberOfEpochs();
    }

    public int getNumberOfSatellites() {
        return this.PlotFile_.getNumberOfSatellites();
    }

    public int getNumberOfScenarios() {
        return this.Scenarios_.size();
    }

    public int getPlotSelection() {
        return this.LastPlotSelection_;
    }

    public String getPlotTitle() {
        return this.PlotTitle_;
    }

    public String getPlotType() {
        return this.PlotFile_.getPlotType();
    }

    public Iterator<Date> getScenarioIterator() {
        return this.Scenarios_.iterator();
    }

    public String getTitle() {
        return this.Parent_.getTitle();
    }

    public String getXAxisLabel() {
        return this.PlotXAxisLabel_;
    }

    public String getYAxisLabel() {
        return this.PlotYAxisLabel_;
    }

    public String i18nString(String key) {
        if (this.Parent_ != null) {
            return this.Parent_.i18nString(key);
        }
        return null;
    }

    public String i18nString(String key, String alt) {
        if (this.Parent_ != null) {
            return this.Parent_.i18nString(key, alt);
        }
        return alt;
    }

    public boolean isKilled(String id, int station, int frequency, int point) {
        return this.PlotList_.isKilled(id, station, frequency, point);
    }

    public boolean isNotKilled(String id, int station, int frequency, int point) {
        return this.PlotList_.isNotKilled(id, station, frequency, point);
    }

    public boolean isListVisible() {
        return this.PlotList_.isVisible();
    }

    public boolean isReading() {
        return this.ReadingFile_ != 0;
    }

    public boolean isScenarioOn() {
        return this.ScenariosOn_;
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
    }

    public void resize(Object newXMin, Object newXMax, Object newYMin, Object newYMax) {
        if (!(this.PlotXMin_.equals(newXMin) && this.PlotXMax_.equals(newXMax) && this.PlotYMin_.equals(newYMin) && this.PlotYMax_.equals(newYMax))) {
            this.PlotXMin_ = newXMin;
            this.PlotXMax_ = newXMax;
            this.PlotYMin_ = newYMin;
            this.PlotYMax_ = newYMax;
            this.PlotStack_.add(this.LastPlotSelection_, newXMin, newXMax, newYMin, newYMax);
            this.PlotStackTop_.set(this.LastPlotSelection_, (short)(this.PlotStack_.size(this.LastPlotSelection_) - 1));
            this.ZoomOutButton_.setEnabled(true);
            this.PlotCanvas_.draw(this.PlotXMin_, this.PlotXMax_, this.PlotYMin_, this.PlotYMax_);
        }
    }

    private void openListFrame(String file_name) {
        this.PlotList_.setVisible(true);
    }

    private void readScenarioFile() {
        this.Scenarios_.clear();
        if (this.FullName_ != null && this.FullName_.length() > 4) {
            File scn_file = new File(this.FullName_.substring(0, this.FullName_.length() - 4) + ".scn");
            if (scn_file.exists()) {
                ScnFile tmp = new ScnFile(scn_file);
                if (tmp.getIos() == 0) {
                    this.Scenarios_ = tmp.getList();
                    tmp = null;
                } else if (tmp.getIos() > 0) {
                    JOptionPane.showMessageDialog(this.Parent_, tmp.getName() + "\n" + this.Parent_.i18nString("ErrorFileRead", "File Read Error") + ": " + tmp.getIos() + "\n" + tmp.getStatus(), this.Parent_.i18nString("ErrorFileRead", "File Read Error"), 2);
                }
            }
            if (this.Scenarios_.size() == 0) {
                // empty if block
            }
        }
    }

    public void removeAllPlotSelections() {
        this.PlotSelection_.removeAllItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBreakInstructions() {
        if (!this.PlotList_.getEditInstructionFormat()) {
            if (this.FullName_ != null) {
                this.BrkName_ = this.FullName_.substring(0, this.FullName_.length() - 4) + ".brk";
                this.BrkFile_ = new File(this.BrkName_);
            }
            if (this.PlotList_.hasBreaks()) {
                if (this.BrkName_ != null) {
                    int n;
                    if (this.BrkFile_.exists() && (n = JOptionPane.showConfirmDialog(this.Parent_, this.BrkName_ + "\n" + this.Parent_.i18nString("WarningFileOverwriteDescription", "Overwrite this file?"), this.Parent_.i18nString("WarningFileOverwrite", "Overwrite File"), 0)) != 0) {
                        this.Status_.setText(this.Parent_.i18nString("SaveBreakInstructionsCancelled", "Save break instructions cancelled."));
                        return;
                    }
                    PrintWriter brk_stream = null;
                    try {
                        brk_stream = new PrintWriter(new FileWriter(this.BrkFile_));
                        Iterator<BreakInstruction> itr = this.PlotList_.getBreakIterator();
                        while (itr.hasNext()) {
                            brk_stream.println(itr.next().toString());
                        }
                        brk_stream.close();
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this.Parent_, this.Parent_.i18nString("ErrorFileOpen", "File Open Error") + ":\n" + ioe.toString(), this.Parent_.i18nString("ErrorFileOpen", "File Open Error"), 0);
                    }
                    finally {
                        if (brk_stream != null) {
                            brk_stream.close();
                        }
                        brk_stream = null;
                    }
                }
            } else if (this.BrkFile_ != null && this.BrkFile_.exists()) {
                this.deleteBrkFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKillInstructions() {
        if (this.PlotList_.hasKills()) {
            this.EdtName_ = this.PlotList_.getEditInstructionFormat() ? this.CurrentPath_ + File.separator + this.Parent_.propString("EngineBaseName", "KPos") + ".edt" : this.FullName_.substring(0, this.FullName_.length() - 4) + ".edt";
            this.EdtFile_ = new File(this.EdtName_);
            if (this.EdtName_ != null) {
                int n;
                if (this.EdtFile_.exists() && !this.PlotList_.getEditInstructionFormat() && (n = JOptionPane.showConfirmDialog(this.Parent_, this.EdtName_ + "\n" + this.Parent_.i18nString("WarningFileOverwriteDescription", "Overwrite this file?"), this.Parent_.i18nString("WarningFileOverwrite", "Overwrite File"), 0)) != 0) {
                    this.Status_.setText(this.Parent_.i18nString("SaveEditInstructionsCancelled", "Save edit instructions cancelled."));
                    return;
                }
                PrintWriter edt_stream = null;
                try {
                    edt_stream = new PrintWriter(new FileWriter(this.EdtFile_, this.PlotList_.getEditInstructionFormat()));
                    Iterator<KillInstruction> itr = this.PlotList_.getKillsIterator();
                    while (itr.hasNext()) {
                        edt_stream.println(itr.next().toString());
                    }
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.Parent_, this.Parent_.i18nString("ErrorFileOpen", "File Open Error") + ":\n" + ioe.toString(), this.Parent_.i18nString("ErrorFileOpen", "File Open Error"), 0);
                }
                finally {
                    if (edt_stream != null) {
                        edt_stream.close();
                    }
                    edt_stream = null;
                }
            }
        } else if (this.EdtFile_.exists()) {
            this.deleteEdtFile();
        }
    }

    public void setDateFormat(String format) {
        if (format != null) {
            this.PlotCanvas_.setDateFormat(format);
            this.PlotList_.setDateFormat(format);
            this.XDateLimits_.setFormat(format);
            this.YDateLimits_.setFormat(format);
            this.repaint();
        }
    }

    public void setLongDateFormat() {
        this.setDateFormat("YYYY-MM-DD");
    }

    public void setProgressBar(int input) {
        this.Progress_.setValue(input);
    }

    public void setProgressBarMaximum(int input) {
        this.Progress_.setMaximum(input);
    }

    public void setProgressBarMinimum(int input) {
        this.Progress_.setMinimum(input);
    }

    public void setShortDateFormat() {
        this.setDateFormat("YYYY-DDD");
    }

    public void setStatusBar(String input) {
        this.Status_.setText(input);
    }

    public void showListHelp() {
        this.Parent_.showListHelp();
    }

    public boolean standsAlone() {
        return this.Parent_.standsAlone();
    }

    public void zoomOut() {
        if (this.PlotStackTop_.get(this.LastPlotSelection_) > 0) {
            this.PlotStack_.remove(this.LastPlotSelection_);
            this.PlotStackTop_.set(this.LastPlotSelection_, (short)(this.PlotStack_.size(this.LastPlotSelection_) - 1));
            if (this.PlotStackTop_.get(this.LastPlotSelection_) == 0) {
                this.ZoomOutButton_.setEnabled(false);
            }
            this.PlotXMin_ = this.PlotStack_.getXMin(this.LastPlotSelection_);
            this.PlotXMax_ = this.PlotStack_.getXMax(this.LastPlotSelection_);
            this.PlotYMin_ = this.PlotStack_.getYMin(this.LastPlotSelection_);
            this.PlotYMax_ = this.PlotStack_.getYMax(this.LastPlotSelection_);
            this.PlotCanvas_.draw(this.PlotXMin_, this.PlotXMax_, this.PlotYMin_, this.PlotYMax_);
        }
    }

    private class SVItemListener
    implements ItemListener {
        private SVItemListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            Matcher match = GnsSelectPattern_.matcher(event.getItem().toString());
            if (match.find(0) && match.group(1) != null) {
                if (event.getStateChange() == 1) {
                    PlotControls.this.PlotCanvas_.showPoints(match.group(1).substring(0, 3));
                } else {
                    PlotControls.this.PlotCanvas_.hidePoints(match.group(1).substring(0, 3));
                }
                PlotControls.this.SelectButton_.setEnabled(true);
                PlotControls.this.DeselectButton_.setEnabled(true);
                PlotControls.this.PlotCanvas_.draw();
            }
        }
    }

    private class ReadPlotFileTask {
        private final int StartOfTask_ = 0;
        private int LengthOfTask_ = 0;
        private long LengthOfFile_ = 0L;
        private boolean Canceled_ = false;
        private boolean Done_ = false;
        private String StatMessage_ = null;
        private final Object[] EnginePlotNames_ = KPosFileFilter.getPlotFileNames().toArray();

        ReadPlotFileTask() {
            this.LengthOfFile_ = PlotControls.this.PlotFile_.length();
            this.LengthOfTask_ = this.LengthOfFile_ > 0L ? 100 : 0;
        }

        public void go() {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ReadPlotFileTask.this.Done_ = false;
                    ReadPlotFileTask.this.Canceled_ = false;
                    ReadPlotFileTask.this.StatMessage_ = null;
                    return new ReadPlotFile();
                }
            };
            worker.start();
        }

        public int getLengthOfTask() {
            return this.LengthOfTask_;
        }

        public int getCurrent() {
            if (this.LengthOfTask_ > 0) {
                return (int)(100L * PlotControls.this.PlotFile_.tell() / PlotControls.this.PlotFile_.length());
            }
            return 0;
        }

        public void stop() {
            this.Canceled_ = true;
            this.StatMessage_ = null;
        }

        public boolean isDone() {
            return this.Done_;
        }

        public String getMessage() {
            return this.StatMessage_;
        }

        private class ReadPlotFile {
            ReadPlotFile() {
                int i;
                PlotControls.this.PlotList_.setVisible(false);
                PlotControls.this.Status_.setText(PlotControls.this.Parent_.i18nString("StatusReadHeader", "Reading file header."));
                PlotControls.this.Progress_.setMinimum(0);
                PlotControls.this.Progress_.setMaximum(ReadPlotFileTask.this.LengthOfTask_);
                PlotControls.this.Progress_.setValue(0);
                if (PlotControls.this.PlotFile_.getPlotType().compareTo("OMNI") == 0) {
                    PlotControls.this.TableModel_.useGnssData();
                } else {
                    PlotControls.this.TableModel_.useXYData(PlotControls.this.PlotFile_.getXType(), PlotControls.this.PlotFile_.getYType());
                }
                ArrayList<Object> x_sto = PlotControls.this.TableModel_.getXStorage();
                ArrayList<HashMap<String, Vector<Object>>> y_sto = PlotControls.this.TableModel_.getYStorage();
                while ((PlotControls.this.LastIOS_ = PlotControls.this.PlotFile_.readDataPoint(x_sto, y_sto)) == 0) {
                    ++PlotControls.this.NumberOfDataPoints_;
                    ReadPlotFileTask.this.StatMessage_ = PlotControls.this.Parent_.i18nString("PointsRead", "Plot points read:") + " " + PlotControls.this.NumberOfDataPoints_ + ".";
                }
                PlotControls.this.PlotFile_.closePlot();
                PlotControls.this.Status_.setText(PlotControls.this.Parent_.i18nString("StatusReadPlot", "Reading file data."));
                PlotControls.this.LastPlotSelection_ = 0;
                PlotControls.this.PlotXMin_ = PlotControls.this.PlotFile_.getXMin();
                PlotControls.this.PlotXMax_ = PlotControls.this.PlotFile_.getXMax();
                PlotControls.this.PlotYMin_ = PlotControls.this.PlotFile_.getYMin(PlotControls.this.LastPlotSelection_);
                PlotControls.this.PlotYMax_ = PlotControls.this.PlotFile_.getYMax(PlotControls.this.LastPlotSelection_);
                PlotControls.this.PlotStackTop_.clear();
                PlotControls.this.PlotStack_.clear();
                for (i = 0; i < PlotControls.this.PlotFile_.getNumberOfPlots(); ++i) {
                    PlotControls.this.PlotStackTop_.add((short)0);
                    PlotControls.this.PlotStack_.init(i, PlotControls.this.PlotFile_.getXMin(), PlotControls.this.PlotFile_.getXMax(), PlotControls.this.PlotFile_.getYMin(i), PlotControls.this.PlotFile_.getYMax(i));
                }
                PlotControls.this.PlotXAxisLabel_ = new String(PlotControls.this.PlotFile_.getXAxisLabel());
                PlotControls.this.PlotYAxisLabel_ = new String(PlotControls.this.PlotFile_.getYAxisLabel());
                PlotControls.this.PlotTitle_ = new String(PlotControls.this.PlotFile_.getTitle(0));
                PlotControls.this.PlotCanvas_.init(PlotControls.this.TableModel_, PlotControls.this.PlotXMin_, PlotControls.this.PlotXMax_, PlotControls.this.PlotYMin_, PlotControls.this.PlotYMax_);
                PlotControls.this.PlotSelection_.removeAllItems();
                for (i = 0; i < PlotControls.this.PlotFile_.getNumberOfPlots(); ++i) {
                    PlotControls.this.PlotSelection_.addItem(PlotControls.this.PlotFile_.getTitle(i));
                }
                PlotControls.this.PlotList_.clearEdits();
                PlotControls.this.PlotList_.setModel(PlotControls.this.TableModel_);
                for (i = 0; i < ReadPlotFileTask.this.EnginePlotNames_.length; ++i) {
                    if (!PlotControls.this.PlotFile_.getName().equalsIgnoreCase((String)ReadPlotFileTask.this.EnginePlotNames_[i])) continue;
                    PlotControls.this.PlotList_.setEditInstructionFormat(true);
                    break;
                }
                if (PlotControls.this.PlotFile_.getPlotType() != null) {
                    PlotControls.this.PlotList_.removeAllItems();
                    Iterator<String> itr = PlotControls.this.PlotFile_.getSvsInFileIterator();
                    int count = 0;
                    while (itr.hasNext()) {
                        String gns = itr.next();
                        PlotControls.this.PlotList_.addItem(count, gns + "- " + PlotControls.this.PlotCanvas_.getSymbol(gns));
                        ++count;
                    }
                }
                PlotControls.this.createSVButtonPanel();
                if (PlotControls.this.PlotXMax_ instanceof Date || PlotControls.this.PlotYMax_ instanceof Date) {
                    // empty if block
                }
                PlotControls.this.Parent_.setTitle(PlotControls.this.Parent_.getProgramName() + ": " + PlotControls.this.PlotFile_.getName());
                PlotControls.this.PlotList_.setTitle(PlotControls.this.Parent_.getProgramName() + ": " + PlotControls.this.PlotFile_.getTitle(0));
                PlotControls.this.setCursor(null);
                ReadPlotFileTask.this.Done_ = true;
            }
        }
    }
}

