/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.GpsTimeZone;
import GPos.Vupos.BreakInstruction;
import GPos.Vupos.PlotControls;
import GPos.Vupos.PlotGnsInfo;
import GPos.Vupos.PlotTableModel;
import GPos.Vupos.Rubberband;
import GPos.Vupos.RubberbandPanel;
import GPos.Vupos.RubberbandRectangle;
import GPosGui.AxisLabels;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PlotCanvas
extends RubberbandPanel
implements MouseMotionListener,
Printable {
    private static final int OFF = -1;
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final int TOLERANCE = 10;
    private static final int MIN_TICK_LENGTH = 4;
    private static final int SPACE_TO_EDGE = 5;
    private static final int SPACE_TO_TEXT = 2;
    private final double EDIT = -9999.0;
    private final double EPS = 0.001;
    private AffineTransform LeftTransform_ = new AffineTransform();
    private AffineTransform NoTransform_ = new AffineTransform();
    private AffineTransform RightTransform_ = new AffineTransform();
    private Color Background_ = Color.WHITE;
    private Color Foreground_ = Color.BLACK;
    private Color XorBackground_ = Color.WHITE;
    private FontMetrics FontMetrics_;
    private Font LabelFont_ = new Font("SansSerif", 1, 14);
    private Font PointFont_ = new Font("SansSerif", 1, 8);
    private Font TickFont_ = new Font("SansSerif", 1, 10);
    private Font TitleFont_ = new Font("SansSerif", 1, 16);
    private FontMetrics SavedMetrics_;
    private Font saved_font;
    private Object LastMaxX_ = null;
    private Object LastMinX_ = null;
    private Object LastMaxY_ = null;
    private Object LastMinY_ = null;
    private Object LastRetX_ = null;
    private Object LastRetY_ = null;
    private Object XMax_;
    private Object XMin_;
    private Object YMax_;
    private Object YMin_;
    private String LastRetGns_;
    private String XAxisType_ = "time";
    private String YAxisType_ = "decimal";
    private boolean DrawPlot_ = true;
    private boolean MaxXOn_ = false;
    private boolean MinXOn_ = false;
    private boolean MaxYOn_ = false;
    private boolean MinYOn_ = false;
    private boolean MouseOn_ = false;
    private boolean Painting_ = false;
    private boolean Printing_ = false;
    private boolean ReticuleOn_ = false;
    private double UOffset_ = 0.0;
    private double URatio_ = 1.0;
    private double VOffset_ = 0.0;
    private double VRatio_ = 1.0;
    private int CanvasHeight_ = 1;
    private int CanvasWidth_ = 1;
    private int EpochToDrawBar_ = -1;
    private int FrameBottom_ = 1;
    private int FrameHeight_ = 1;
    private int FrameLeft_ = 0;
    private int FrameRight_ = 1;
    private int FrameTop_ = 0;
    private int FrameWidth_ = 1;
    private int[] LabelOffsets_ = new int[]{-1, -1, -1, -1};
    private int LetterHeight_ = 1;
    private int LetterHalfHeight_ = 1;
    private int MajorTickLength_ = 4;
    private int MinorTickLength_ = 4;
    private int TickLength_ = 4;
    private int[] SecondTickOffsets_ = new int[]{-1, -1, -1, -1};
    private int[] TickOffsets_ = new int[]{-1, -1, -1, -1};
    private int[] TitleOffsets_ = new int[]{-1, -1, -1, -1};
    private int U0_ = 0;
    private int U1_ = 1;
    private int UWidth_ = 1;
    private int V0_ = 0;
    private int V1_ = 1;
    private int VWidth_ = 1;
    private ArrayList<Color> CCho_ = new ArrayList();
    private ArrayList<Integer> XCho_ = new ArrayList();
    private ArrayList<Integer> YCho_ = new ArrayList();
    private HashMap<String, PlotGnsInfo> GnsList_ = new HashMap();
    private Image Buffer_;
    private Image LeftBuffer_;
    private Image RightBuffer_;
    private JPopupMenu ZoomMenu_ = new JPopupMenu();
    private PlotControls Parent_;
    private AxisLabels XAxis_ = new AxisLabels((TimeZone)new GpsTimeZone());
    private AxisLabels YAxis_ = new AxisLabels((TimeZone)new GpsTimeZone());
    private PlotTableModel TableModel_;
    public static final int XMIN = 0;
    public static final int XMAX = 1;
    public static final int YMIN = 2;
    public static final int YMAX = 3;
    public static final int PreferredXTicks_ = 7;
    public static final int PreferredYTicks_ = 5;

    public PlotCanvas(PlotControls parent) {
        this.Parent_ = parent;
        this.setSize(750, 550);
        this.setRubberband(new RubberbandRectangle());
        this.addMouseMotionListener(this);
        this.createPopupMenu();
        this.LeftTransform_.rotate(-1.5707963267948966);
        this.NoTransform_.setToIdentity();
        this.RightTransform_.rotate(1.5707963267948966);
    }

    public PlotCanvas(PlotControls parent, String date_format) {
        this(parent);
        this.setDateFormat(date_format);
    }

    public void autoscale(Object x_min_orig, Object x_max_orig, Object y_min_orig, Object y_max_orig) {
        PlotGnsInfo info;
        String gns2;
        Set<String> gns_list;
        Object x_max = x_min_orig;
        Object x_min = x_max_orig;
        Object y_max = y_min_orig;
        Object y_min = y_max_orig;
        ArrayList<Object> x_sto = this.TableModel_.getXStorage();
        ArrayList<HashMap<String, Vector<Object>>> y_sto = this.TableModel_.getYStorage();
        Iterator<String> gns_itr = this.Parent_.getGnsListIterator();
        int current_subplot = this.Parent_.getPlotSelection();
        for (int i = 0; i < x_sto.size(); ++i) {
            Object x_val = x_sto.get(i);
            HashMap<String, Vector<Object>> data = y_sto.get(i);
            gns_list = data.keySet();
            for (String gns2 : gns_list) {
                info = this.GnsList_.get(gns2);
                if (!info.isVisible() || !this.Parent_.isNotKilled(gns2, 1, current_subplot + 1, i + 1)) continue;
                Object y_val = data.get(gns2).get(current_subplot);
                if (this.XAxisType_.equalsIgnoreCase("decimal")) {
                    if (StrictMath.abs((Double)x_val - -9999.0) > 0.001) {
                        if (((Double)x_max).compareTo((Double)x_val) < 0) {
                            x_max = x_val;
                        }
                        if (((Double)x_min).compareTo((Double)x_val) > 0) {
                            x_min = x_val;
                        }
                    }
                } else {
                    if (((Date)x_max).before((Date)x_val)) {
                        x_max = x_val;
                    }
                    if (((Date)x_min).after((Date)x_val)) {
                        x_min = x_val;
                    }
                }
                if (this.YAxisType_.equalsIgnoreCase("decimal")) {
                    if (!(StrictMath.abs((Double)y_val - -9999.0) > 0.001)) continue;
                    if (((Double)y_max).compareTo((Double)y_val) < 0) {
                        y_max = y_val;
                    }
                    if (((Double)y_min).compareTo((Double)y_val) <= 0) continue;
                    y_min = y_val;
                    continue;
                }
                if (((Date)y_max).before((Date)y_val)) {
                    y_max = y_val;
                }
                if (!((Date)y_min).after((Date)y_val)) continue;
                y_min = y_val;
            }
        }
        info = null;
        gns_list = null;
        gns2 = null;
        gns_itr = null;
        x_sto = null;
        if (this.XAxisType_.equalsIgnoreCase("decimal")) {
            if (((Double)x_max).compareTo((Double)x_min) > 0) {
                if (this.YAxisType_.equalsIgnoreCase("decimal") && ((Double)y_max).compareTo((Double)y_min) > 0) {
                    this.Parent_.resize(x_min, x_max, y_min, y_max);
                } else if (((Date)y_max).after((Date)y_min)) {
                    this.Parent_.resize(x_min, x_max, y_min, y_max);
                }
            }
        } else if (((Date)x_max).after((Date)x_min)) {
            if (this.YAxisType_.equalsIgnoreCase("decimal") && ((Double)y_max).compareTo((Double)y_min) > 0) {
                this.Parent_.resize(x_min, x_max, y_min, y_max);
            } else if (((Date)y_max).after((Date)y_min)) {
                this.Parent_.resize(x_min, x_max, y_min, y_max);
            }
        }
    }

    public void createGnsList() {
        this.GnsList_.clear();
        Iterator<String> itr = this.Parent_.getGnsListIterator();
        while (itr.hasNext()) {
            String gns = itr.next();
            this.GnsList_.put(gns, new PlotGnsInfo(gns));
        }
    }

    private void createPopupMenu() {
        JMenuItem item = new JMenuItem("Autoscale");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotCanvas.this.PopupItemActionPerformed(evt);
            }
        });
        this.ZoomMenu_.add(item);
        item = new JMenuItem("Zoom Out");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlotCanvas.this.PopupItemActionPerformed(evt);
            }
        });
        this.ZoomMenu_.add(item);
        this.setPopupMenu(this.ZoomMenu_);
    }

    public void draw() {
        this.DrawPlot_ = true;
        this.repaint();
    }

    public void draw(PlotTableModel model, Object xmin, Object xmax, Object ymin, Object ymax) {
        this.init(model, xmin, xmax, ymin, ymax);
        this.DrawPlot_ = true;
        this.repaint();
    }

    public void draw(Object xmin, Object xmax, Object ymin, Object ymax) {
        this.setRange(xmin, xmax, ymin, ymax);
        this.DrawPlot_ = true;
        this.repaint();
    }

    private void drawBreakLines(Graphics page, boolean is_visible, String current_gns) {
        if (is_visible) {
            Color saved_color = page.getColor();
            page.setColor(Color.YELLOW);
            Iterator<BreakInstruction> itr = this.Parent_.getBreakInstructionIterator();
            while (itr.hasNext()) {
                Date x;
                BreakInstruction bi = itr.next();
                boolean is_gns = bi.getGnsId().substring(0, 3).equals(current_gns.substring(0, 3));
                if (!is_gns || !this.okX(x = bi.getEpoch())) continue;
                int x_bar = this.screenX(x);
                page.drawLine(x_bar, this.FrameTop_, x_bar, this.FrameBottom_);
            }
            page.setColor(saved_color);
        }
    }

    private void drawFrame(Graphics page) {
        page.setColor(this.Background_);
        page.fillRect(0, 0, this.CanvasWidth_, this.CanvasHeight_);
        page.setColor(this.Foreground_);
        page.drawRect(this.FrameLeft_, this.FrameTop_, this.FrameWidth_ - 1, this.FrameHeight_ - 1);
    }

    private void drawMaxX(Graphics page) {
        if (this.MaxXOn_ && this.LastMaxX_ != null && this.okX(this.LastMaxX_)) {
            Color saved_color = page.getColor();
            page.setColor(Color.BLUE);
            int x_bar = this.screenX(this.LastMaxX_);
            page.drawLine(x_bar, this.FrameTop_, x_bar, this.FrameBottom_);
            page.setColor(saved_color);
        }
    }

    private void drawMaxY(Graphics page) {
        if (this.MaxYOn_ && this.LastMaxY_ != null && this.okY(this.LastMaxY_)) {
            Color saved_color = page.getColor();
            page.setColor(Color.BLUE);
            int y_bar = this.screenY(this.LastMaxY_);
            page.drawLine(this.FrameLeft_, y_bar, this.FrameRight_, y_bar);
            page.setColor(saved_color);
        }
    }

    private void drawMinX(Graphics page) {
        if (this.MinXOn_ && this.LastMinX_ != null && this.okX(this.LastMinX_)) {
            Color saved_color = page.getColor();
            page.setColor(Color.BLUE);
            int x_bar = this.screenX(this.LastMinX_);
            page.drawLine(x_bar, this.FrameTop_, x_bar, this.FrameBottom_);
            page.setColor(saved_color);
        }
    }

    private void drawMinY(Graphics page) {
        if (this.MinYOn_ && this.LastMinY_ != null && this.okY(this.LastMinY_)) {
            Color saved_color = page.getColor();
            page.setColor(Color.BLUE);
            int y_bar = this.screenY(this.LastMinY_);
            page.drawLine(this.FrameLeft_, y_bar, this.FrameRight_, y_bar);
            page.setColor(saved_color);
        }
    }

    private void drawPlot() {
        if (this.DrawPlot_) {
            this.Buffer_ = this.createImage(this.getSize().width, this.getSize().height);
            Graphics tmp = this.Buffer_.getGraphics();
            this.drawPlot(tmp);
        }
        this.DrawPlot_ = false;
    }

    private void drawPlot(Graphics page) {
        if (this.DrawPlot_ && this.XMax_ != null) {
            PlotGnsInfo info;
            String gns3;
            Set<String> gns_list;
            String current_selection;
            int current_subplot = this.Parent_.getPlotSelection();
            String current_gns = current_selection.substring(0, (current_selection = this.Parent_.getListSelection()).length() < 3 ? current_selection.length() : 3);
            boolean is_list_visible = this.Parent_.isListVisible();
            this.getOffsets(page);
            if (this.XAxisType_.compareTo("time") == 0) {
                this.XAxis_.getTimeLabels((Date)this.XMin_, (Date)this.XMax_, 7, true, true);
            } else {
                this.XAxis_.getDecimalLabels((Double)this.XMin_, (Double)this.XMax_, 7, true, true);
            }
            if (this.YAxisType_.compareTo("time") == 0) {
                this.YAxis_.getTimeLabels((Date)this.YMin_, (Date)this.YMax_, 5, true, true);
            } else {
                this.YAxis_.getDecimalLabels((Double)this.YMin_, (Double)this.YMax_, 5, true, true);
            }
            this.drawFrame(page);
            this.drawTitle(this.Parent_.getPlotTitle(), page);
            this.drawXAxisTicks(page);
            this.drawXAxisLabel(this.Parent_.getXAxisLabel(), page);
            this.drawYTickMarks(page);
            this.LeftBuffer_ = this.createImage(this.FrameLeft_, this.FrameHeight_);
            Graphics alt = this.LeftBuffer_.getGraphics();
            alt.setColor(this.Background_);
            alt.fillRect(0, 0, this.FrameLeft_, this.FrameHeight_);
            this.drawLeftLabels(alt);
            this.RightBuffer_ = this.createImage(this.CanvasWidth_ - this.FrameRight_ + 1, this.FrameHeight_);
            alt = this.RightBuffer_.getGraphics();
            alt.setColor(this.Background_);
            alt.fillRect(0, 0, this.CanvasWidth_ - this.FrameRight_ + 1, this.FrameHeight_);
            this.drawRightLabels(alt);
            page.setPaintMode();
            page.drawImage(this.LeftBuffer_, 0, this.FrameTop_, this.Background_, this);
            page.drawImage(this.RightBuffer_, this.FrameRight_ + 1, this.FrameTop_, this);
            this.drawScenarioLines(page);
            Iterator<String> gns_itr = this.Parent_.getGnsListIterator();
            while (gns_itr.hasNext()) {
                String gns2 = gns_itr.next();
                this.GnsList_.get(gns2).reset(this.FontMetrics_);
            }
            ArrayList<Object> x_sto = this.TableModel_.getXStorage();
            ArrayList<HashMap<String, Vector<Object>>> y_sto = this.TableModel_.getYStorage();
            for (int i = 0; i < x_sto.size(); ++i) {
                Object value = x_sto.get(i);
                HashMap<String, Vector<Object>> data = y_sto.get(i);
                if (!this.okX(value)) continue;
                int x = this.screenX(value);
                gns_list = data.keySet();
                for (String gns3 : gns_list) {
                    info = this.GnsList_.get(gns3);
                    if (!info.isVisible() || !this.okY(value = data.get(gns3).get(current_subplot))) continue;
                    boolean killed = this.Parent_.isKilled(gns3, 1, current_subplot + 1, i + 1);
                    int y = this.screenY(value);
                    if (is_list_visible) {
                        if (gns3.compareTo(current_gns) == 0) {
                            this.XCho_.add(x);
                            this.YCho_.add(y);
                            if (killed) {
                                this.CCho_.add(Color.PINK);
                            } else {
                                this.CCho_.add(Color.RED);
                            }
                        }
                        if (killed) continue;
                        info.draw(page, x, y, Color.GRAY);
                        continue;
                    }
                    if (killed) continue;
                    info.draw(page, x, y, this.Foreground_);
                }
            }
            this.drawBreakLines(page, is_list_visible, current_gns);
            if (is_list_visible) {
                info = this.GnsList_.get(current_gns);
                Iterator<Color> ic = this.CCho_.iterator();
                Iterator<Integer> ix = this.XCho_.iterator();
                Iterator<Integer> iy = this.YCho_.iterator();
                while (ix.hasNext()) {
                    info.draw(page, ix.next(), iy.next(), ic.next());
                }
                ic = null;
                ix = null;
                iy = null;
                this.CCho_.clear();
                this.XCho_.clear();
                this.YCho_.clear();
            }
            info = null;
            gns_list = null;
            gns3 = null;
            gns_itr = null;
            x_sto = null;
            y_sto = null;
        }
        this.DrawPlot_ = false;
    }

    private void drawReticule(Graphics page) {
        if (this.ReticuleOn_) {
            Color saved_color = page.getColor();
            page.setColor(Color.RED);
            if (this.LastRetX_ != null && this.okX(this.LastRetX_)) {
                int x_bar = this.screenX(this.LastRetX_);
                page.drawLine(x_bar, this.FrameTop_, x_bar, this.FrameBottom_);
            }
            if (this.LastRetY_ != null && this.okY(this.LastRetY_)) {
                int y_bar = this.screenY(this.LastRetY_);
                page.drawLine(this.FrameLeft_, y_bar, this.FrameRight_, y_bar);
            }
            page.setColor(saved_color);
        }
    }

    private void drawScenarioLines(Graphics page) {
        if (this.Parent_.isScenarioOn() && this.Parent_.getNumberOfScenarios() > 0) {
            Color saved_color = page.getColor();
            page.setColor(Color.GREEN);
            Iterator<Date> itr = this.Parent_.getScenarioIterator();
            while (itr.hasNext()) {
                Date x = itr.next();
                if (!this.okX(x)) continue;
                int x_bar = this.screenX(x);
                page.drawLine(x_bar, this.FrameTop_, x_bar, this.FrameBottom_);
            }
            page.setColor(saved_color);
        }
    }

    private void drawTitle(String title, Graphics page) {
        if (title == null || title.length() == 0) {
            return;
        }
        this.saved_font = page.getFont();
        page.setFont(this.TitleFont_);
        FontMetrics font_metrics = page.getFontMetrics();
        if (this.TitleOffsets_[2] != -1) {
            page.drawString(title, (this.CanvasWidth_ - font_metrics.stringWidth(title) + 1) / 2, this.TitleOffsets_[2]);
        }
        if (this.TitleOffsets_[0] != -1) {
            page.drawString(title, (this.CanvasWidth_ - font_metrics.stringWidth(title) + 1) / 2, this.TitleOffsets_[0]);
        }
        if (this.TitleOffsets_[3] != -1) {
            page.setFont(this.TitleFont_.deriveFont(this.LeftTransform_));
            page.drawString(title, this.TitleOffsets_[3], (this.CanvasHeight_ + font_metrics.stringWidth(title) + 1) / 2);
        }
        if (this.TitleOffsets_[1] != -1) {
            page.setFont(this.TitleFont_.deriveFont(this.RightTransform_));
            page.drawString(title, this.TitleOffsets_[1], (this.CanvasHeight_ - font_metrics.stringWidth(title) + 1) / 2);
        }
        page.setFont(this.saved_font);
    }

    private void drawXAxisLabel(String label, Graphics page) {
        if (label == null || label.length() == 0) {
            return;
        }
        this.saved_font = page.getFont();
        page.setFont(this.LabelFont_);
        FontMetrics font_metrics = page.getFontMetrics();
        if (this.LabelOffsets_[2] != -1) {
            page.drawString(label, (this.FrameWidth_ - font_metrics.stringWidth(label) + 1) / 2, this.LabelOffsets_[2]);
        }
        if (this.LabelOffsets_[0] != -1) {
            page.drawString(label, (this.FrameWidth_ - font_metrics.stringWidth(label) + 1) / 2, this.LabelOffsets_[0]);
        }
        page.setFont(this.saved_font);
    }

    private void drawXAxisTicks(Graphics page) {
        int x;
        String string;
        this.saved_font = page.getFont();
        page.setFont(this.TickFont_);
        FontMetrics font_metrics = page.getFontMetrics();
        SortedMap<Object, String> labels = this.XAxis_.getALabels();
        for (Object value : labels.keySet()) {
            string = (String)labels.get(value);
            x = this.screenX(value);
            page.drawLine(x, this.FrameBottom_ - (string.length() == 0 ? this.MinorTickLength_ : this.MajorTickLength_), x, this.FrameBottom_);
            page.drawLine(x, this.FrameTop_, x, this.FrameTop_ + (string.length() == 0 ? this.MinorTickLength_ : this.MajorTickLength_));
            if (this.TickOffsets_[2] != -1) {
                page.drawString(string, x - (font_metrics.stringWidth(string) + 1) / 2, this.TickOffsets_[2]);
            }
            if (this.TickOffsets_[0] == -1) continue;
            page.drawString(string, x - (font_metrics.stringWidth(string) + 1) / 2, this.TickOffsets_[0]);
        }
        if (this.SecondTickOffsets_[2] != -1) {
            labels = this.XAxis_.getBLabels();
            for (Object value : labels.keySet()) {
                string = (String)labels.get(value);
                x = this.screenX(value);
                page.drawString(string, x - (font_metrics.stringWidth(string) + 1) / 2, this.SecondTickOffsets_[2]);
            }
        }
        if (this.SecondTickOffsets_[0] != -1) {
            labels = this.XAxis_.getBLabels();
            for (Object value : labels.keySet()) {
                string = (String)labels.get(value);
                x = this.screenX(value);
                page.drawString(string, x - (font_metrics.stringWidth(string) + 1) / 2, this.SecondTickOffsets_[0]);
            }
        }
        page.setFont(this.saved_font);
    }

    private void drawLeftLabels(Graphics page) {
        int half_width;
        this.saved_font = page.getFont();
        page.setColor(this.Foreground_);
        ((Graphics2D)page).rotate(-1.5707963267948966);
        page.setFont(this.LabelFont_);
        FontMetrics font_metrics = page.getFontMetrics();
        String label = this.Parent_.getYAxisLabel();
        if (this.LabelOffsets_[3] != -1 && label != null && label.length() > 0) {
            int width = font_metrics.stringWidth(label);
            page.drawString(label, -(this.FrameHeight_ + width) / 2, this.LabelOffsets_[3]);
        }
        page.setFont(this.TickFont_);
        font_metrics = page.getFontMetrics();
        SortedMap<Object, String> labels = this.YAxis_.getALabels();
        if (this.TickOffsets_[3] != -1) {
            for (Object value : labels.keySet()) {
                label = (String)labels.get(value);
                half_width = font_metrics.stringWidth(label) / 2;
                page.drawString(label, -(this.screenY(value) - this.FrameTop_ + half_width), this.TickOffsets_[3]);
            }
        }
        if (this.SecondTickOffsets_[3] != -1) {
            labels = this.YAxis_.getBLabels();
            for (Object value : labels.keySet()) {
                label = (String)labels.get(value);
                half_width = font_metrics.stringWidth(label) / 2;
                page.drawString(label, -(this.screenY(value) - this.FrameTop_ + half_width), this.SecondTickOffsets_[3]);
            }
        }
        ((Graphics2D)page).rotate(1.5707963267948966);
        page.setFont(this.saved_font);
    }

    private void drawRightLabels(Graphics page) {
        int half_width;
        this.saved_font = page.getFont();
        page.setColor(this.Foreground_);
        ((Graphics2D)page).rotate(-1.5707963267948966);
        page.setFont(this.LabelFont_);
        FontMetrics font_metrics = page.getFontMetrics();
        String label = this.Parent_.getYAxisLabel();
        if (this.LabelOffsets_[1] != -1 && label != null && label.length() > 0) {
            int width = font_metrics.stringWidth(label);
            page.drawString(label, -(this.FrameHeight_ + width) / 2, this.LabelOffsets_[1] - this.FrameRight_ + 1);
        }
        this.saved_font = page.getFont();
        page.setFont(this.TickFont_);
        font_metrics = page.getFontMetrics();
        SortedMap<Object, String> labels = this.YAxis_.getALabels();
        if (this.TickOffsets_[1] != -1) {
            for (Object value : labels.keySet()) {
                label = (String)labels.get(value);
                half_width = font_metrics.stringWidth(label) / 2;
                page.drawString(label, -(this.screenY(value) - this.FrameTop_ + half_width), this.TickOffsets_[1] - this.FrameRight_ + 1);
            }
        }
        if (this.SecondTickOffsets_[1] != -1) {
            labels = this.YAxis_.getBLabels();
            for (Object value : labels.keySet()) {
                label = (String)labels.get(value);
                half_width = font_metrics.stringWidth(label) / 2;
                page.drawString(label, -(this.screenY(value) - this.FrameTop_ + half_width), this.SecondTickOffsets_[1] - this.FrameRight_ + 1);
            }
        }
        ((Graphics2D)page).rotate(1.5707963267948966);
        page.setFont(this.saved_font);
    }

    private void drawYTickMarks(Graphics page) {
        SortedMap<Object, String> labels = this.YAxis_.getALabels();
        for (Object value : labels.keySet()) {
            String string = (String)labels.get(value);
            int y = this.screenY(value);
            page.drawLine(this.FrameLeft_, y, this.FrameLeft_ + (string.length() == 0 ? this.MinorTickLength_ : this.MajorTickLength_), y);
            page.drawLine(this.FrameRight_ - (string.length() == 0 ? this.MinorTickLength_ : this.MajorTickLength_), y, this.FrameRight_, y);
        }
    }

    private void getBottomOffsets(Graphics page, boolean show_plot_title, boolean show_axis_label, boolean show_tick_labels) {
        FontMetrics font_metrics;
        Integer position = this.getSize().height - 1;
        this.saved_font = page.getFont();
        int space = 5;
        if (show_plot_title) {
            page.setFont(this.TitleFont_);
            font_metrics = page.getFontMetrics();
            position = position - (space + font_metrics.getMaxDescent());
            this.TitleOffsets_[2] = position;
            position = position - font_metrics.getMaxAscent();
            space = 2;
        } else {
            this.TitleOffsets_[2] = -1;
        }
        if (show_axis_label) {
            page.setFont(this.LabelFont_);
            font_metrics = page.getFontMetrics();
            position = position - (space + font_metrics.getMaxDescent());
            this.LabelOffsets_[2] = position;
            position = position - font_metrics.getMaxAscent();
            space = 2;
        } else {
            this.LabelOffsets_[2] = -1;
        }
        if (show_tick_labels) {
            page.setFont(this.TickFont_);
            font_metrics = page.getFontMetrics();
            position = position - (space + font_metrics.getMaxDescent());
            if (this.XAxisType_.compareTo("time") == 0) {
                this.SecondTickOffsets_[2] = position;
                position = position - font_metrics.getHeight();
            } else {
                this.SecondTickOffsets_[2] = -1;
            }
            this.TickOffsets_[2] = position;
            position = position - font_metrics.getMaxAscent();
            space = 2;
        } else {
            this.SecondTickOffsets_[2] = -1;
            this.TickOffsets_[2] = -1;
        }
        position = position - space;
        this.FrameBottom_ = position;
        page.setFont(this.saved_font);
    }

    private void getLeftOffsets(Graphics page, boolean show_plot_title, boolean show_axis_label, boolean show_tick_labels) {
        FontMetrics font_metrics;
        Integer position = 0;
        this.saved_font = page.getFont();
        int space = 5;
        if (show_plot_title) {
            page.setFont(this.TitleFont_);
            font_metrics = page.getFontMetrics();
            position = position + (space + font_metrics.getMaxAscent());
            this.TitleOffsets_[3] = position;
            position = position + font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.TitleOffsets_[3] = -1;
        }
        if (show_axis_label) {
            page.setFont(this.LabelFont_);
            font_metrics = page.getFontMetrics();
            position = position + (space + font_metrics.getMaxAscent());
            this.LabelOffsets_[3] = position;
            position = position + font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.LabelOffsets_[3] = -1;
        }
        if (show_tick_labels) {
            page.setFont(this.TickFont_);
            font_metrics = page.getFontMetrics();
            position = position + (space + font_metrics.getMaxAscent());
            if (this.YAxisType_.compareTo("time") == 0) {
                this.SecondTickOffsets_[3] = position;
                position = position + font_metrics.getHeight();
            } else {
                this.SecondTickOffsets_[3] = -1;
            }
            this.TickOffsets_[3] = position;
            position = position + font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.SecondTickOffsets_[3] = -1;
            this.TickOffsets_[3] = -1;
        }
        position = position + space;
        this.FrameLeft_ = position;
        page.setFont(this.saved_font);
    }

    private void getOffsets(Graphics page) {
        this.saved_font = page.getFont();
        this.CanvasHeight_ = this.getSize().height;
        this.CanvasWidth_ = this.getSize().width;
        page.setFont(this.PointFont_);
        this.FontMetrics_ = page.getFontMetrics();
        this.LetterHeight_ = this.FontMetrics_.getHeight();
        this.LetterHalfHeight_ = (this.LetterHeight_ + 1) / 2;
        boolean title_flag = this.Parent_.getTitle() != null && this.Parent_.getTitle().trim().length() > 0;
        boolean x_label_flag = this.Parent_.getXAxisLabel() != null && this.Parent_.getXAxisLabel().trim().length() > 0;
        boolean y_label_flag = this.Parent_.getYAxisLabel() != null && this.Parent_.getYAxisLabel().trim().length() > 0;
        this.getTopOffsets(page, title_flag, false, false);
        this.getBottomOffsets(page, false, x_label_flag, true);
        this.getLeftOffsets(page, false, y_label_flag, true);
        this.getRightOffsets(page, false, false, false);
        this.FrameHeight_ = this.FrameBottom_ - this.FrameTop_ + 1;
        this.FrameWidth_ = this.FrameRight_ - this.FrameLeft_ + 1;
        this.U0_ = this.FrameLeft_ + this.LetterHalfHeight_;
        this.U1_ = this.FrameRight_ - this.LetterHalfHeight_;
        this.V0_ = this.FrameTop_ + this.LetterHalfHeight_;
        this.V1_ = this.FrameBottom_ - this.LetterHalfHeight_;
        this.UWidth_ = this.U1_ - this.U0_ + 1;
        if (this.XAxisType_.compareToIgnoreCase("decimal") == 0) {
            this.URatio_ = (double)this.UWidth_ / ((Double)this.XMax_ - (Double)this.XMin_);
            this.UOffset_ = this.URatio_ * (Double)this.XMin_;
        } else {
            this.URatio_ = (double)this.UWidth_ / (double)(((Date)this.XMax_).getTime() - ((Date)this.XMin_).getTime());
            this.UOffset_ = this.URatio_ * (double)((Date)this.XMin_).getTime();
        }
        this.VWidth_ = this.V1_ - this.V0_ + 1;
        if (this.YAxisType_.compareToIgnoreCase("decimal") == 0) {
            this.VRatio_ = (double)this.VWidth_ / ((Double)this.YMax_ - (Double)this.YMin_);
            this.VOffset_ = this.VRatio_ * (Double)this.YMax_;
        } else {
            this.VRatio_ = (double)this.VWidth_ / (double)(((Date)this.YMax_).getTime() - ((Date)this.YMin_).getTime());
            this.VOffset_ = this.VRatio_ * (double)((Date)this.YMin_).getTime();
        }
        this.TickLength_ = this.FrameWidth_ < this.FrameHeight_ ? this.FrameWidth_ / 20 : this.FrameHeight_ / 20;
        this.TickLength_ = this.TickLength_ < 4 ? this.TickLength_ : 4;
        this.MinorTickLength_ = this.FrameWidth_ < this.FrameHeight_ ? this.FrameWidth_ / 40 : this.FrameHeight_ / 40;
        this.MinorTickLength_ = this.MinorTickLength_ < 4 ? this.MinorTickLength_ : 4;
        this.MajorTickLength_ = 2 * this.MinorTickLength_;
        page.setFont(this.saved_font);
    }

    private void getRightOffsets(Graphics page, boolean show_plot_title, boolean show_axis_label, boolean show_tick_labels) {
        FontMetrics font_metrics;
        Integer position = this.getSize().width - 1;
        this.saved_font = page.getFont();
        int space = 5;
        if (show_plot_title) {
            page.setFont(this.TitleFont_);
            font_metrics = page.getFontMetrics();
            position = position - (space + font_metrics.getMaxAscent());
            this.TitleOffsets_[1] = position;
            position = position - font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.TitleOffsets_[1] = -1;
        }
        if (show_axis_label) {
            page.setFont(this.LabelFont_);
            font_metrics = page.getFontMetrics();
            position = position - (space + font_metrics.getMaxAscent());
            this.LabelOffsets_[1] = position;
            position = position - font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.LabelOffsets_[1] = -1;
        }
        if (show_tick_labels) {
            page.setFont(this.TickFont_);
            font_metrics = page.getFontMetrics();
            position = position - (space + font_metrics.getMaxAscent());
            if (this.YAxisType_.compareTo("time") == 0) {
                this.SecondTickOffsets_[1] = position;
                position = position - font_metrics.getHeight();
            } else {
                this.SecondTickOffsets_[1] = -1;
            }
            this.TickOffsets_[1] = position;
            position = position - font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.SecondTickOffsets_[1] = -1;
            this.TickOffsets_[1] = -1;
        }
        position = position - space;
        this.FrameRight_ = position;
        page.setFont(this.saved_font);
    }

    public String getSymbol(String input) {
        if (this.GnsList_.containsKey(input)) {
            return this.GnsList_.get(input).getSymbol();
        }
        return null;
    }

    private void getTopOffsets(Graphics page, boolean show_plot_title, boolean show_axis_label, boolean show_tick_labels) {
        FontMetrics font_metrics;
        Integer position = 0;
        this.saved_font = page.getFont();
        int space = 5;
        if (show_plot_title) {
            page.setFont(this.TitleFont_);
            font_metrics = page.getFontMetrics();
            position = position + (space + font_metrics.getMaxAscent());
            this.TitleOffsets_[0] = position;
            position = position + font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.TitleOffsets_[0] = -1;
        }
        if (show_axis_label) {
            page.setFont(this.LabelFont_);
            font_metrics = page.getFontMetrics();
            position = position + (space + font_metrics.getMaxAscent());
            this.LabelOffsets_[0] = position;
            position = position + font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.LabelOffsets_[0] = -1;
        }
        if (show_tick_labels) {
            page.setFont(this.TickFont_);
            font_metrics = page.getFontMetrics();
            position = position + (space + font_metrics.getMaxAscent());
            if (this.XAxisType_.compareTo("time") == 0) {
                this.SecondTickOffsets_[0] = position;
                position = position + font_metrics.getHeight();
            } else {
                this.SecondTickOffsets_[0] = -1;
            }
            this.TickOffsets_[0] = position;
            position = position + font_metrics.getMaxDescent();
            space = 2;
        } else {
            this.SecondTickOffsets_[0] = -1;
            this.TickOffsets_[0] = -1;
        }
        position = position + space;
        this.FrameTop_ = position;
        page.setFont(this.saved_font);
    }

    public Object getXMax() {
        return this.XMax_;
    }

    public Object getXMin() {
        return this.XMin_;
    }

    public Object getYMax() {
        return this.YMax_;
    }

    public Object getYMin() {
        return this.YMin_;
    }

    public void hidePoints(String gns) {
        if (this.GnsList_.containsKey(gns)) {
            this.GnsList_.get(gns).hide();
        }
    }

    public void init(PlotTableModel model, Object xmin, Object xmax, Object ymin, Object ymax) {
        this.TableModel_ = model;
        this.XAxisType_ = this.TableModel_.getColumnObject(1) instanceof Date ? "time" : "decimal";
        this.YAxisType_ = this.TableModel_.getColumnObject(2) instanceof Date ? "time" : "decimal";
        this.setRange(xmin, xmax, ymin, ymax);
        this.createGnsList();
    }

    public void maxXLimitAt(Object x, boolean force) {
        this.DrawPlot_ = force;
        this.LastMaxX_ = x;
        this.repaint();
    }

    public void maxYLimitAt(Object y, boolean force) {
        this.DrawPlot_ = force;
        this.LastMaxY_ = y;
        this.repaint();
    }

    public void minXLimitAt(Object x, boolean force) {
        this.DrawPlot_ = force;
        this.LastMinX_ = x;
        this.repaint();
    }

    public void minYLimitAt(Object y, boolean force) {
        this.DrawPlot_ = force;
        this.LastMinY_ = y;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.MouseOn_) {
            int x = e.getPoint().x - this.U0_;
            int y = e.getPoint().y - this.V0_;
            Object X = this.worldX(x);
            Object Y = this.worldY(y);
            this.Parent_.setStatusBar("Point: (" + x + ", " + y + ") = " + X.toString() + ", " + Y.toString());
        }
    }

    private boolean okToPaint() {
        return this.TableModel_ != null && !this.Painting_ && !this.Parent_.isReading();
    }

    private boolean okX(Object value) {
        return this.XAxisType_.equalsIgnoreCase("decimal") ? ((Double)value).compareTo((Double)this.XMin_) >= 0 && ((Double)value).compareTo((Double)this.XMax_) <= 0 : ((Date)value).compareTo((Date)this.XMin_) >= 0 && ((Date)value).compareTo((Date)this.XMax_) <= 0;
    }

    private boolean okY(Object value) {
        return this.YAxisType_.equalsIgnoreCase("decimal") ? ((Double)value).compareTo((Double)this.YMin_) >= 0 && ((Double)value).compareTo((Double)this.YMax_) <= 0 && StrictMath.abs((Double)value - -9999.0) > 0.001 : ((Date)value).compareTo((Date)this.YMin_) >= 0 && ((Date)value).compareTo((Date)this.YMax_) <= 0;
    }

    private void PopupItemActionPerformed(ActionEvent evt) {
        String s = ((JMenuItem)evt.getSource()).getText();
        if (s.equalsIgnoreCase("Autoscale")) {
            this.Parent_.autoscale();
        } else if (s.equalsIgnoreCase("Zoom Out")) {
            this.Parent_.zoomOut();
        }
    }

    public void PrintCanvas() throws PrinterException {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(OrientationRequested.LANDSCAPE);
        aset.add(new JobName("Vupos", null));
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length > 0) {
            pj.setPrintService(services[0]);
            if (pj.printDialog(aset)) {
                pj.print(aset);
            }
        }
    }

    public void paint(Graphics page) {
        if (this.okToPaint()) {
            this.Painting_ = true;
            if (this.Printing_) {
                this.drawPlot(page);
            } else {
                this.drawPlot();
                page.drawImage(this.Buffer_, 0, 0, this);
            }
            this.drawReticule(page);
            this.drawMinX(page);
            this.drawMaxX(page);
            this.drawMinY(page);
            this.drawMaxY(page);
            this.Painting_ = false;
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            this.Parent_.setStatusBar("Printing ...");
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            int old_width = this.getSize().width;
            int old_height = this.getSize().height;
            int w = 650;
            int h = 503;
            this.setSize(w, h);
            g2d.setClip(0, 0, w, h);
            this.Printing_ = true;
            this.DrawPlot_ = true;
            this.paint(g2d);
            this.Printing_ = false;
            g2d.dispose();
            g2d = null;
            this.setSize(old_width, old_height);
            this.Parent_.clearStatusBar();
            return 0;
        }
        return 1;
    }

    public void reticuleAt(Object x, Object y, boolean force) {
        this.DrawPlot_ = force;
        this.LastRetX_ = x;
        this.LastRetY_ = y;
        this.repaint();
    }

    public void reticuleAt(int index) {
        this.reticuleAt(this.TableModel_.getX(index), this.TableModel_.getY(index), false);
    }

    public void reticuleAt(int index, boolean force) {
        this.reticuleAt(this.TableModel_.getX(index), this.TableModel_.getY(index), force);
    }

    public void reticuleOff() {
        if (this.ReticuleOn_) {
            this.DrawPlot_ = true;
            this.ReticuleOn_ = false;
            this.repaint();
        }
    }

    public void reticuleOn(Object x, Object y) {
        if (!this.ReticuleOn_) {
            this.DrawPlot_ = true;
            this.ReticuleOn_ = true;
            this.LastRetX_ = x;
            this.LastRetY_ = y;
            this.repaint();
        }
    }

    public void reticuleOn(int index) {
        if (this.TableModel_ != null) {
            this.reticuleOn(this.TableModel_.getX(index), this.TableModel_.getY(index));
        }
    }

    public void rubberbandEnded(Rubberband rb) {
        int miny;
        int maxy;
        int minx;
        int maxx;
        Point anchor = rb.getAnchor();
        Point end = rb.getEnd();
        if (anchor.x > end.x) {
            maxx = anchor.x;
            minx = end.x;
        } else {
            maxx = end.x;
            minx = anchor.x;
        }
        if (anchor.y < end.y) {
            maxy = anchor.y;
            miny = end.y;
        } else {
            maxy = end.y;
            miny = anchor.y;
        }
        if (Math.abs(maxx - minx) < 10 || Math.abs(maxy - miny) < 10) {
            return;
        }
        minx = StrictMath.max(minx, this.U0_) - this.U0_;
        maxx = StrictMath.min(maxx, this.U1_) - this.U0_;
        miny = StrictMath.max(miny, this.V0_) - this.V0_;
        maxy = StrictMath.min(maxy, this.V1_) - this.V0_;
        this.Parent_.resize(this.worldX(minx), this.worldX(maxx), this.worldY(miny), this.worldY(maxy));
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.Background_ = color;
            this.DrawPlot_ = true;
            this.drawPlot();
        }
    }

    public void setDateFormat(String input) {
        if (!input.equalsIgnoreCase(this.XAxis_.getDateFormat().toString()) || !input.equalsIgnoreCase(this.YAxis_.getDateFormat().toString())) {
            if (input.equalsIgnoreCase(AxisLabels.DateFormat.LONG.toString())) {
                this.XAxis_.setDateFormat(AxisLabels.DateFormat.LONG);
                this.YAxis_.setDateFormat(AxisLabels.DateFormat.LONG);
            } else {
                this.XAxis_.setDateFormat(AxisLabels.DateFormat.SHORT);
                this.YAxis_.setDateFormat(AxisLabels.DateFormat.SHORT);
            }
            this.DrawPlot_ = true;
            this.repaint();
        }
    }

    public void setDrawingColor(Color n) {
        Iterator<String> gns_itr = this.Parent_.getGnsListIterator();
        while (gns_itr.hasNext()) {
            this.GnsList_.get(gns_itr.next()).setColor(n);
        }
        this.DrawPlot_ = true;
        this.repaint();
    }

    public void setForeground(Color color) {
        if (color != null) {
            this.Foreground_ = color;
            this.DrawPlot_ = true;
            this.repaint();
        }
    }

    public void setLimitsAt(int type, Object value, boolean force) {
        switch (type) {
            case 0: {
                this.minXLimitAt(value, force);
                break;
            }
            case 1: {
                this.maxXLimitAt(value, force);
                break;
            }
            case 2: {
                this.minYLimitAt(value, force);
                break;
            }
            case 3: {
                this.maxYLimitAt(value, force);
            }
        }
    }

    public void setRange(Object xmin, Object xmax, Object ymin, Object ymax) {
        this.XMin_ = xmin;
        this.XMax_ = xmax;
        this.YMin_ = ymin;
        this.YMax_ = ymax;
    }

    public void showPoints(String gns) {
        if (this.GnsList_.containsKey(gns)) {
            this.GnsList_.get(gns).show();
        }
    }

    private int screenX(Object x) {
        if (this.XAxisType_.equalsIgnoreCase("decimal")) {
            return this.U0_ + (int)(this.URatio_ * (Double)x - this.UOffset_ + 0.5);
        }
        return this.U0_ + (int)(this.URatio_ * (double)((Date)x).getTime() - this.UOffset_ + 0.5);
    }

    private int screenY(Object y) {
        if (this.YAxisType_.equalsIgnoreCase("decimal")) {
            return this.V0_ + (int)(this.VOffset_ - this.VRatio_ * (Double)y + 0.5);
        }
        return this.V0_ + (int)(this.VOffset_ - this.VRatio_ * (double)((Date)y).getTime() + 0.5);
    }

    public void setEpochToDrawBar(int index) {
        this.EpochToDrawBar_ = index;
        this.repaint();
    }

    public void setXMax(double x) {
        this.XMax_ = x;
    }

    public void setXMin(double x) {
        this.XMin_ = x;
    }

    public void setYMax(double y) {
        this.YMax_ = y;
    }

    public void setYMin(double y) {
        this.YMin_ = y;
    }

    private Object worldX(int x) {
        if (this.XAxisType_.equalsIgnoreCase("decimal")) {
            return new Double((Double)this.XMin_ + (double)x / this.URatio_);
        }
        return new Date(((Date)this.XMin_).getTime() + (long)((double)x / this.URatio_));
    }

    private Object worldY(int y) {
        if (this.YAxisType_.equalsIgnoreCase("decimal")) {
            return new Double((Double)this.YMax_ - (double)y / this.VRatio_);
        }
        return new Date(((Date)this.YMax_).getTime() - (long)((double)y / this.VRatio_));
    }

    public void xLimitsAt(Object min_x, Object max_x, boolean force) {
        this.DrawPlot_ = force;
        this.LastMaxX_ = max_x;
        this.LastMinX_ = min_x;
        this.repaint();
    }

    public void xLimitsOff() {
        if (this.MaxXOn_ || this.MinXOn_) {
            this.DrawPlot_ = true;
            this.MaxXOn_ = false;
            this.MinXOn_ = false;
            this.repaint();
        }
    }

    public void xLimitsOn(Object min_x, Object max_x) {
        if (!this.MaxXOn_ || !this.MinXOn_) {
            this.DrawPlot_ = true;
            this.MaxXOn_ = true;
            this.MinXOn_ = true;
            this.LastMaxX_ = max_x;
            this.LastMinX_ = min_x;
            this.repaint();
        }
    }

    public void yLimitsAt(Object min_y, Object max_y, boolean force) {
        this.DrawPlot_ = force;
        this.LastMaxY_ = max_y;
        this.LastMinY_ = min_y;
        this.repaint();
    }

    public void yLimitsOff() {
        if (this.MaxYOn_ || this.MinYOn_) {
            this.DrawPlot_ = true;
            this.MaxYOn_ = false;
            this.MinYOn_ = false;
            this.repaint();
        }
    }

    public void yLimitsOn(Object min_y, Object max_y) {
        if (!this.MaxYOn_ || !this.MinYOn_) {
            this.DrawPlot_ = true;
            this.MaxYOn_ = true;
            this.MinYOn_ = true;
            this.LastMaxY_ = max_y;
            this.LastMinY_ = min_y;
            this.repaint();
        }
    }
}

