/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ListTableModel
extends AbstractTableModel {
    protected int PageSize_;
    protected int PageOffset_;
    protected Object[][] Data_;
    private String[] ColumnNames_ = new String[]{"Point", "Epoch", "Value"};
    public final Object[] longValues = new Object[]{new Integer(10000), new Date(0L), "0.000000"};

    public ListTableModel(Object[][] table, int size) {
        this.Data_ = table;
        this.PageSize_ = size;
    }

    public int getRowCount() {
        return this.PageSize_;
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int col) {
        int realRow = row + this.PageOffset_ * this.PageSize_;
        return this.Data_[realRow][col];
    }

    public String getColumnName(int col) {
        return this.ColumnNames_[col];
    }

    public int getPageOffset() {
        return this.PageOffset_;
    }

    public int getPageCount() {
        return (int)Math.ceil((double)this.Data_.length / (double)this.PageSize_);
    }

    public int getRealRowCount() {
        return this.Data_.length;
    }

    public int getPageSize() {
        return this.PageSize_;
    }

    public void setPageSize(int s) {
        if (s == this.PageSize_) {
            return;
        }
        int oldPageSize = this.PageSize_;
        this.PageSize_ = s;
        if (this.PageSize_ < oldPageSize) {
            this.fireTableRowsDeleted(this.PageSize_, oldPageSize - 1);
        } else {
            this.fireTableRowsInserted(oldPageSize, this.PageSize_ - 1);
        }
    }

    public void setToFirstPage() {
        this.PageOffset_ = 0;
        this.fireTableDataChanged();
    }

    public void setToPage(int index) {
        if (index < 0) {
            this.PageOffset_ = 0;
        } else if (index > this.getPageCount() - 1) {
            this.PageOffset_ = this.getPageCount() - 1;
        } else {
            this.PageOffset_ = index;
            this.fireTableDataChanged();
        }
    }

    public void pageDown() {
        if (this.PageOffset_ < this.getPageCount() - 1) {
            ++this.PageOffset_;
            this.fireTableDataChanged();
        }
    }

    public void pageUp() {
        if (this.PageOffset_ > 0) {
            --this.PageOffset_;
            this.fireTableDataChanged();
        }
    }

    public static JScrollPane createPagingScrollPaneForTable(JTable jt) {
        JScrollPane jsp = new JScrollPane(jt);
        if (!(jt.getModel() instanceof ListTableModel)) {
            return jsp;
        }
        ListTableModel model = (ListTableModel)jt.getModel();
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setHorizontalScrollBarPolicy(32);
        return jsp;
    }
}

