/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.GpsTimeZone;
import GPos.Vupos.EditInstruction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class KillInstruction
extends EditInstruction {
    private final Integer Freq1_;
    private final Integer Freq2_;
    private final Integer Pt1_;
    private final Integer Pt2_;
    private final Integer StaId1_;
    private final Integer StaId2_;
    private static final Double Edit_ = -9999.0;
    private static final SimpleDateFormat NewEpochFormat_ = new SimpleDateFormat("yyyy MM dd HH mm ss");
    private static final SimpleDateFormat OldEpochFormat_ = new SimpleDateFormat("yyyy-DDD HH:mm:ss.SS");
    private Date LastEpoch_ = null;

    public KillInstruction(String gns_id, Integer sta_1, Integer sta_2, Integer freq_1, Integer freq_2, Integer pt_1, Integer pt_2, Date epoch) {
        super(gns_id, epoch);
        if (sta_1 == null) {
            throw new NullPointerException();
        }
        NewEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        OldEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.StaId1_ = sta_1;
        this.StaId2_ = sta_2;
        this.Freq1_ = freq_1;
        this.Freq2_ = freq_2;
        this.Pt1_ = pt_1;
        this.Pt2_ = pt_2;
    }

    public KillInstruction(String gns_id, Integer sta_1, Integer sta_2, Integer pt_1, Integer pt_2, Date epoch) {
        super(gns_id, epoch);
        if (sta_1 == null) {
            throw new NullPointerException();
        }
        NewEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        OldEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.StaId1_ = sta_1;
        this.StaId2_ = sta_2;
        this.Freq1_ = 1;
        this.Freq2_ = 2;
        this.Pt1_ = pt_1;
        this.Pt2_ = pt_2;
    }

    public KillInstruction(String gns_id, Integer sta_1, Integer sta_2, Integer freq_1, Integer freq_2, Integer pt_1, Integer pt_2, Date first_epoch, Date last_epoch) {
        super(gns_id, first_epoch);
        if (sta_1 == null) {
            throw new NullPointerException();
        }
        NewEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        OldEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.StaId1_ = sta_1;
        this.StaId2_ = sta_2;
        this.Freq1_ = freq_1;
        this.Freq2_ = freq_2;
        this.Pt1_ = pt_1;
        this.Pt2_ = pt_2;
        this.LastEpoch_ = last_epoch;
    }

    public KillInstruction(String gns_id, Integer sta_1, Integer sta_2, Integer pt_1, Integer pt_2, Date first_epoch, Date last_epoch) {
        super(gns_id, first_epoch);
        if (sta_1 == null) {
            throw new NullPointerException();
        }
        NewEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        OldEpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.StaId1_ = sta_1;
        this.StaId2_ = sta_2;
        this.Freq1_ = 1;
        this.Freq2_ = 2;
        this.Pt1_ = pt_1;
        this.Pt2_ = pt_2;
        this.LastEpoch_ = last_epoch;
    }

    public Integer getStaId1() {
        return this.StaId1_;
    }

    public Integer getStaId2() {
        return this.StaId2_;
    }

    public Integer getFreq1() {
        return this.Freq1_;
    }

    public Integer getFreq2() {
        return this.Freq2_;
    }

    public Integer getPt1() {
        return this.Pt1_;
    }

    public Integer getPt2() {
        return this.Pt2_;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KillInstruction)) {
            return false;
        }
        KillInstruction n = (KillInstruction)o;
        return super.equals(o) && n.StaId1_.equals(this.StaId1_) && n.StaId2_.equals(this.StaId2_) && n.Freq1_.equals(this.Freq1_) && n.Freq2_.equals(this.Freq2_) && n.Pt1_.equals(this.Pt1_) && n.Pt2_.equals(this.Pt2_);
    }

    public boolean isKilled(String id, int station, int frequency, int point) {
        return (id.equals(this.getGnsId()) || id.equals(KillInstruction.getAllId()) || KillInstruction.getAllId().equals(id)) && station >= this.StaId1_ && station <= this.StaId2_ && frequency >= this.Freq1_ && frequency <= this.Freq2_ && point >= this.Pt1_ && point <= this.Pt2_;
    }

    public String toString() {
        if (this.LastEpoch_ == null) {
            return " " + this.getGnsId().substring(1, 3) + " " + this.formatInteger(this.StaId1_, 2) + " " + this.formatInteger(this.StaId2_, 2) + " " + this.formatInteger(this.Freq1_, 2) + " " + this.formatInteger(this.Freq2_, 2) + " " + this.formatInteger(this.Pt1_, 6) + " " + this.formatInteger(this.Pt2_, 6) + " " + this.formatDouble(Edit_, 12, 0) + " " + this.formatInteger(this.Pt2_ - this.Pt1_ + 1, 4) + " kill" + " " + OldEpochFormat_.format(this.getEpoch());
        }
        return " " + this.getGnsId().substring(1, 3) + " " + this.formatInteger(this.StaId1_, 2) + " " + NewEpochFormat_.format(this.getEpoch()) + " " + NewEpochFormat_.format(this.LastEpoch_) + " " + this.formatDouble(Edit_, 12, 0) + " " + this.formatDouble(Edit_, 12, 0);
    }

    public String toString(String input) {
        if (this.LastEpoch_ == null) {
            return " " + this.getGnsId().substring(1, 3) + " " + this.formatInteger(this.StaId1_, 2) + " " + this.formatInteger(this.StaId2_, 2) + " " + this.formatInteger(this.Freq1_, 2) + " " + this.formatInteger(this.Freq2_, 2) + " " + this.formatInteger(this.Pt1_, 6) + " " + this.formatInteger(this.Pt2_, 6) + " " + this.formatDouble(Edit_, 12, 0) + " " + this.formatInteger(this.Pt2_ - this.Pt1_ + 1, 4) + " " + input + " " + OldEpochFormat_.format(this.getEpoch());
        }
        return " " + this.getGnsId().substring(1, 3) + " " + this.formatInteger(this.StaId1_, 2) + " " + NewEpochFormat_.format(this.getEpoch()) + " " + NewEpochFormat_.format(this.LastEpoch_) + " " + this.formatDouble(Edit_, 12, 0) + " " + this.formatDouble(Edit_, 12, 0);
    }
}

