/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditInstruction
implements Comparable<EditInstruction> {
    private final Date Epoch_;
    private final String GnsId_;
    private static final String AllId_ = "G00";
    private static final String Blanks_ = "                    ";
    private static final String Zeros_ = "00000000000000000000";

    public static String getAllId() {
        return AllId_;
    }

    public EditInstruction(String gns_id, Date epoch) {
        if (gns_id == null || epoch == null) {
            throw new NullPointerException();
        }
        this.GnsId_ = gns_id;
        this.Epoch_ = epoch;
    }

    @Override
    public int compareTo(EditInstruction n) {
        int lastCmp = this.GnsId_.equals(AllId_) || n.GnsId_.equals(AllId_) ? 0 : this.GnsId_.compareTo(n.GnsId_);
        if (lastCmp == 0) {
            return this.Epoch_.compareTo(n.Epoch_);
        }
        return lastCmp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EditInstruction)) {
            return false;
        }
        return this.compareTo((EditInstruction)o) == 0;
    }

    public String formatDouble(double value, int width, int decimals) {
        double incr = 0.5;
        for (int j = decimals; j > 0; --j) {
            incr /= 10.0;
        }
        value = value < 0.0 ? (value -= incr) : (value += incr);
        String tmp = Double.toString(value);
        int n1 = tmp.indexOf(46);
        int n2 = tmp.length() - n1 - 1;
        if (decimals > n2) {
            tmp = tmp + Zeros_.substring(0, decimals - n2);
        } else if (n2 > decimals) {
            tmp = tmp.substring(0, n1 + decimals + 1);
        }
        if (width > 0 && width > tmp.length()) {
            tmp = Blanks_.substring(0, width - tmp.length()) + tmp;
        } else if (width < 0 && -width > tmp.length()) {
            width = -width;
            tmp = tmp + Blanks_.substring(0, width - tmp.length());
        }
        return tmp;
    }

    public String formatInteger(int value, int width) {
        String tmp = Integer.toString(value);
        if (width > 0 && width > tmp.length()) {
            tmp = Blanks_.substring(0, width - tmp.length()) + tmp;
        } else if (width < 0 && -width > tmp.length()) {
            width = -width;
            tmp = tmp + Blanks_.substring(0, width - tmp.length());
        }
        return tmp;
    }

    public String getGnsId() {
        return this.GnsId_;
    }

    public Date getEpoch() {
        return this.Epoch_;
    }

    public int hashCode() {
        return 31 * this.GnsId_.hashCode() + this.Epoch_.hashCode();
    }
}

