/*
 * Decompiled with CFR 0.152.
 */
package GPos.Vupos;

import GNSS.GpsTimeZone;
import GPos.Vupos.EditInstruction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class BreakInstruction
extends EditInstruction {
    private final Integer Pt_;
    private final Integer StaId_;
    private static final String Blanks_ = "   ";
    private static final SimpleDateFormat EpochFormat_ = new SimpleDateFormat("yyyy  MM  dd  HH  mm  ss.SS");

    public BreakInstruction(String gns_id, Integer sta_id, Integer point, Date epoch) {
        super(gns_id, epoch);
        if (sta_id == null || point == null) {
            throw new NullPointerException();
        }
        EpochFormat_.setTimeZone((TimeZone)new GpsTimeZone());
        this.Pt_ = point;
        this.StaId_ = sta_id;
    }

    public Integer getStaId() {
        return this.StaId_;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BreakInstruction)) {
            return false;
        }
        BreakInstruction n = (BreakInstruction)o;
        return n.getGnsId().equals(this.getGnsId()) && n.StaId_.equals(this.StaId_) && n.getEpoch().equals(this.getEpoch());
    }

    public int hashCode() {
        return 31 * (31 * this.getGnsId().hashCode() + this.StaId_.hashCode()) + this.getEpoch().hashCode();
    }

    public boolean isBreak(String id, int station, int point) {
        return id.substring(0, 3).equals(this.getGnsId().substring(0, 3)) && station == this.StaId_ && point == this.Pt_;
    }

    public String toString() {
        return Blanks_ + this.getGnsId().substring(1, 3) + Blanks_.substring(0, 3 - this.StaId_.toString().length()) + this.StaId_.toString() + "  " + EpochFormat_.format(this.getEpoch());
    }

    public int compareTo(BreakInstruction n) {
        int lastCmp = this.getGnsId().compareTo(n.getGnsId());
        if (this.getGnsId().compareTo(n.getGnsId()) == 0) {
            lastCmp = this.StaId_.compareTo(n.StaId_);
            if (lastCmp == 0) {
                return this.getEpoch().compareTo(n.getEpoch());
            }
            return lastCmp;
        }
        return lastCmp;
    }
}

